/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ipc;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.function.Function;
import org.cryptomator.cryptolib.common.ByteBuffers;
import org.cryptomator.ipc.HandleLaunchArgsMessage;
import org.cryptomator.ipc.RevealRunningAppMessage;

sealed interface IpcMessage
permits HandleLaunchArgsMessage, RevealRunningAppMessage {
    public MessageType getMessageType();

    public ByteBuffer encodePayload();

    public static IpcMessage receive(ReadableByteChannel channel) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(8);
        if (ByteBuffers.fill((ReadableByteChannel)channel, (ByteBuffer)header) < header.capacity()) {
            throw new EOFException();
        }
        header.flip();
        int typeNo = header.getInt();
        int length = header.getInt();
        MessageType type = MessageType.forOrdinal(typeNo);
        ByteBuffer payload = ByteBuffer.allocate(length);
        ByteBuffers.fill((ReadableByteChannel)channel, (ByteBuffer)payload);
        payload.flip();
        return type.decodePayload(payload);
    }

    default public void send(WritableByteChannel channel) throws IOException {
        ByteBuffer payload = this.encodePayload();
        ByteBuffer buf = ByteBuffer.allocate(8 + payload.remaining());
        buf.putInt(this.getMessageType().ordinal());
        buf.putInt(payload.remaining());
        buf.put(payload);
        buf.flip();
        while (buf.hasRemaining()) {
            channel.write(buf);
        }
    }

    public static enum MessageType {
        REVEAL_RUNNING_APP(RevealRunningAppMessage::decode),
        HANDLE_LAUNCH_ARGS(HandleLaunchArgsMessage::decode);

        private final Function<ByteBuffer, IpcMessage> decoder;

        private MessageType(Function<ByteBuffer, IpcMessage> decoder) {
            this.decoder = decoder;
        }

        static MessageType forOrdinal(int ordinal) {
            try {
                return MessageType.values()[ordinal];
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("No such message type: " + ordinal, e);
            }
        }

        IpcMessage decodePayload(ByteBuffer payload) {
            return this.decoder.apply(payload);
        }
    }
}

