/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ipc;

import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import org.cryptomator.ipc.IpcCommunicator;
import org.cryptomator.ipc.IpcMessage;
import org.cryptomator.ipc.IpcMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Client
implements IpcCommunicator {
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private final SocketChannel socketChannel;

    private Client(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public static Client create(Path socketPath) throws IOException {
        UnixDomainSocketAddress address = UnixDomainSocketAddress.of(socketPath);
        SocketChannel socketChannel = SocketChannel.open(address);
        LOG.info("Connected to IPC server on socket {}", (Object)socketPath);
        return new Client(socketChannel);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void listen(IpcMessageListener listener, Executor executor) {
        executor.execute(() -> {
            try {
                while (this.socketChannel.isConnected()) {
                    IpcMessage msg = IpcMessage.receive(this.socketChannel);
                    listener.handleMessage(msg);
                }
            }
            catch (IOException e) {
                LOG.error("Failed to read IPC message", (Throwable)e);
            }
        });
    }

    @Override
    public void send(IpcMessage message, Executor executor) {
        executor.execute(() -> {
            try {
                message.send(this.socketChannel);
            }
            catch (IOException e) {
                LOG.error("Failed to send IPC message", (Throwable)e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.close();
    }
}

