/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValueBase;
import javax.inject.Inject;
import org.cryptomator.common.vaults.PerVault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerVault
public class VaultState
extends ObservableValueBase<Value>
implements ObservableObjectValue<Value> {
    private static final Logger LOG = LoggerFactory.getLogger(VaultState.class);
    private final AtomicReference<Value> value;
    private final Lock lock = new ReentrantLock();
    private final Condition valueChanged = this.lock.newCondition();

    @Inject
    public VaultState(Value initialValue) {
        this.value = new AtomicReference<Value>(initialValue);
    }

    public Value get() {
        return this.getValue();
    }

    public Value getValue() {
        return this.value.get();
    }

    public boolean transition(Value fromState, Value toState) {
        Preconditions.checkArgument((fromState != toState ? 1 : 0) != 0, (Object)"fromState must be different than toState");
        boolean success = this.value.compareAndSet(fromState, toState);
        if (success) {
            this.fireValueChangedEvent();
        } else {
            LOG.debug("Failed transiting into state {}: Expected state was not {}.", (Object)fromState, (Object)toState);
        }
        return success;
    }

    public void set(Value newState) {
        Value oldState = this.value.getAndSet(newState);
        if (oldState != newState) {
            this.fireValueChangedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitState(Value desiredState, long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            long remaining = TimeUnit.NANOSECONDS.convert(time, unit);
            while (this.value.get() != desiredState) {
                if (remaining <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                remaining = this.valueChanged.awaitNanos(remaining);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void signal() {
        this.lock.lock();
        try {
            this.valueChanged.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void fireValueChangedEvent() {
        this.signal();
        if (Platform.isFxApplicationThread()) {
            super.fireValueChangedEvent();
        } else {
            Platform.runLater(() -> super.fireValueChangedEvent());
        }
    }

    public static enum Value {
        MISSING,
        NEEDS_MIGRATION,
        LOCKED,
        PROCESSING,
        UNLOCKED,
        ERROR;

    }
}

