/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mount;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.common.Environment;
import org.cryptomator.common.mount.ConflictingMountServiceException;
import org.cryptomator.common.mount.IllegalMountPointException;
import org.cryptomator.common.mount.MountPointInUseException;
import org.cryptomator.common.mount.MountPointNotExistingException;
import org.cryptomator.common.mount.MountPointNotSupportedException;
import org.cryptomator.common.mount.MountWithinParentUtil;
import org.cryptomator.common.mount.WindowsDriveLetters;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Mounter {
    private static final Logger LOG = LoggerFactory.getLogger(Mounter.class);
    private static final Map<String, Set<String>> CONFLICTING_MOUNT_SERVICES = Map.of("org.cryptomator.frontend.fuse.mount.MacFuseMountProvider", Set.of("org.cryptomator.frontend.fuse.mount.FuseTMountProvider"), "org.cryptomator.frontend.fuse.mount.FuseTMountProvider", Set.of("org.cryptomator.frontend.fuse.mount.MacFuseMountProvider"));
    private final Environment env;
    private final Settings settings;
    private final WindowsDriveLetters driveLetters;
    private final List<MountService> mountProviders;
    private final Set<MountService> usedMountServices;
    private final ObservableValue<MountService> defaultMountService;

    @Inject
    public Mounter(Environment env, Settings settings, WindowsDriveLetters driveLetters, List<MountService> mountProviders, @Named(value="usedMountServices") Set<MountService> usedMountServices, ObservableValue<MountService> defaultMountService) {
        this.env = env;
        this.settings = settings;
        this.driveLetters = driveLetters;
        this.mountProviders = mountProviders;
        this.usedMountServices = usedMountServices;
        this.defaultMountService = defaultMountService;
    }

    public MountHandle mount(VaultSettings vaultSettings, Path cryptoFsRoot) throws IOException, MountFailedException {
        MountService mountService = this.mountProviders.stream().filter(s -> s.getClass().getName().equals(vaultSettings.mountService.getValue())).findFirst().orElse((MountService)this.defaultMountService.getValue());
        if (this.isConflictingMountService(mountService)) {
            String msg = String.valueOf(mountService.getClass()) + " unavailable due to conflict with either of " + String.valueOf(CONFLICTING_MOUNT_SERVICES.get(mountService.getClass().getName()));
            throw new ConflictingMountServiceException(msg);
        }
        this.usedMountServices.add(mountService);
        MountBuilder builder = mountService.forFileSystem(cryptoFsRoot);
        SettledMounter internal = new SettledMounter(mountService, builder, vaultSettings);
        Runnable cleanup = internal.prepare();
        return new MountHandle(builder.mount(), mountService.hasCapability(MountCapability.UNMOUNT_FORCED), cleanup);
    }

    public boolean isConflictingMountService(MountService service) {
        Set conflictingServices = CONFLICTING_MOUNT_SERVICES.getOrDefault(service.getClass().getName(), Set.of());
        return this.usedMountServices.stream().map(MountService::getClass).map(Class::getName).anyMatch(conflictingServices::contains);
    }

    private class SettledMounter {
        private final MountService service;
        private final MountBuilder builder;
        private final VaultSettings vaultSettings;

        public SettledMounter(MountService service, MountBuilder builder, VaultSettings vaultSettings) {
            this.service = service;
            this.builder = builder;
            this.vaultSettings = vaultSettings;
        }

        Runnable prepare() throws IOException {
            for (MountCapability capability : this.service.capabilities()) {
                switch (capability) {
                    case FILE_SYSTEM_NAME: {
                        this.builder.setFileSystemName("cryptoFs");
                        break;
                    }
                    case LOOPBACK_PORT: {
                        if (this.vaultSettings.mountService.getValue() == null) {
                            this.builder.setLoopbackPort(Mounter.this.settings.port.get());
                            break;
                        }
                        this.builder.setLoopbackPort(this.vaultSettings.port.get());
                        break;
                    }
                    case LOOPBACK_HOST_NAME: {
                        Mounter.this.env.getLoopbackAlias().ifPresent(arg_0 -> ((MountBuilder)this.builder).setLoopbackHostName(arg_0));
                        break;
                    }
                    case READ_ONLY: {
                        this.builder.setReadOnly(this.vaultSettings.usesReadOnlyMode.get());
                        break;
                    }
                    case MOUNT_FLAGS: {
                        String mountFlags = (String)this.vaultSettings.mountFlags.get();
                        if (mountFlags == null || mountFlags.isBlank()) {
                            this.builder.setMountFlags(this.service.getDefaultMountFlags());
                            break;
                        }
                        this.builder.setMountFlags(mountFlags);
                        break;
                    }
                    case VOLUME_ID: {
                        this.builder.setVolumeId(this.vaultSettings.id);
                        break;
                    }
                    case VOLUME_NAME: {
                        this.builder.setVolumeName((String)this.vaultSettings.mountName.get());
                    }
                }
            }
            return this.prepareMountPoint();
        }

        private Runnable prepareMountPoint() throws IOException {
            Runnable cleanup = () -> {};
            Path userChosenMountPoint = (Path)this.vaultSettings.mountPoint.get();
            Path defaultMountPointBase = Mounter.this.env.getMountPointsDir().orElseThrow();
            boolean canMountToDriveLetter = this.service.hasCapability(MountCapability.MOUNT_AS_DRIVE_LETTER);
            boolean canMountToParent = this.service.hasCapability(MountCapability.MOUNT_WITHIN_EXISTING_PARENT);
            boolean canMountToDir = this.service.hasCapability(MountCapability.MOUNT_TO_EXISTING_DIR);
            boolean canMountToSystem = this.service.hasCapability(MountCapability.MOUNT_TO_SYSTEM_CHOSEN_PATH);
            if (userChosenMountPoint == null) {
                if (!canMountToSystem) {
                    if (canMountToDriveLetter) {
                        this.builder.setMountpoint(Mounter.this.driveLetters.getFirstDesiredAvailable().orElseThrow());
                    } else if (canMountToParent) {
                        Files.createDirectories(defaultMountPointBase, new FileAttribute[0]);
                        this.builder.setMountpoint(defaultMountPointBase);
                    } else if (canMountToDir) {
                        Path mountPoint = defaultMountPointBase.resolve((String)this.vaultSettings.mountName.get());
                        Files.createDirectories(mountPoint, new FileAttribute[0]);
                        this.builder.setMountpoint(mountPoint);
                    }
                }
            } else {
                boolean mpIsDriveLetter = userChosenMountPoint.toString().matches("[A-Z]:\\\\");
                if (mpIsDriveLetter) {
                    if (Mounter.this.driveLetters.getOccupied().contains(userChosenMountPoint)) {
                        throw new MountPointInUseException(userChosenMountPoint);
                    }
                } else if (canMountToParent && !canMountToDir) {
                    MountWithinParentUtil.prepareParentNoMountPoint(userChosenMountPoint);
                    cleanup = () -> MountWithinParentUtil.cleanup(userChosenMountPoint);
                }
                try {
                    this.builder.setMountpoint(userChosenMountPoint);
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    boolean configNotSupported;
                    boolean bl = configNotSupported = !canMountToDriveLetter && mpIsDriveLetter || !canMountToDir && !mpIsDriveLetter || !canMountToParent && !mpIsDriveLetter || !canMountToDir && !canMountToParent && !canMountToSystem && !canMountToDriveLetter;
                    if (configNotSupported) {
                        throw new MountPointNotSupportedException(userChosenMountPoint, e.getMessage());
                    }
                    if (canMountToDir && !canMountToParent && !Files.exists(userChosenMountPoint, new LinkOption[0])) {
                        throw new MountPointNotExistingException(userChosenMountPoint, e.getMessage());
                    }
                    throw new IllegalMountPointException(userChosenMountPoint, e.getMessage());
                }
            }
            return cleanup;
        }
    }

    public record MountHandle(Mount mountObj, boolean supportsUnmountForced, Runnable specialCleanup) {
    }
}

