/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.locationpresets;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.cryptomator.common.locationpresets.LocationPreset;
import org.cryptomator.common.locationpresets.LocationPresetsProvider;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;

@OperatingSystem(value=OperatingSystem.Value.MAC)
@CheckAvailability
public final class DropboxMacLocationPresetsProvider
implements LocationPresetsProvider {
    private static final Path LOCATION = LocationPresetsProvider.resolveLocation("~/Library/CloudStorage/Dropbox");
    private static final Path FALLBACK_LOCATION = LocationPresetsProvider.resolveLocation("~/Dropbox");

    @CheckAvailability
    public static boolean isPresent() {
        return Files.isDirectory(LOCATION, new LinkOption[0]) || Files.isDirectory(FALLBACK_LOCATION, new LinkOption[0]);
    }

    @Override
    public Stream<LocationPreset> getLocations() {
        if (Files.isDirectory(LOCATION, new LinkOption[0])) {
            return Stream.of(new LocationPreset("Dropbox", LOCATION));
        }
        if (Files.isDirectory(FALLBACK_LOCATION, new LinkOption[0])) {
            return Stream.of(new LocationPreset("Dropbox", FALLBACK_LOCATION));
        }
        return Stream.of(new LocationPreset[0]);
    }
}

