/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import java.util.Optional;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.LicenseChecker;
import org.cryptomator.common.settings.Settings;

@Singleton
public class LicenseHolder {
    private final Settings settings;
    private final LicenseChecker licenseChecker;
    private final ObjectProperty<DecodedJWT> validJwtClaims;
    private final ObservableValue<String> licenseSubject;
    private final BooleanBinding validLicenseProperty;

    @Inject
    public LicenseHolder(LicenseChecker licenseChecker, Settings settings) {
        this.settings = settings;
        this.licenseChecker = licenseChecker;
        this.validJwtClaims = new SimpleObjectProperty();
        this.licenseSubject = this.validJwtClaims.map(Payload::getSubject);
        this.validLicenseProperty = this.validJwtClaims.isNotNull();
        Optional<DecodedJWT> claims = licenseChecker.check((String)settings.licenseKey.get());
        this.validJwtClaims.set((Object)claims.orElse(null));
    }

    public boolean validateAndStoreLicense(String licenseKey) {
        Optional<DecodedJWT> claims = this.licenseChecker.check(licenseKey);
        this.validJwtClaims.set((Object)claims.orElse(null));
        if (claims.isPresent()) {
            this.settings.licenseKey.set((Object)licenseKey);
            return true;
        }
        return false;
    }

    public Optional<String> getLicenseKey() {
        DecodedJWT claims = (DecodedJWT)this.validJwtClaims.get();
        if (claims != null) {
            return Optional.of(claims.getToken());
        }
        return Optional.empty();
    }

    public ObservableValue<String> licenseSubjectProperty() {
        return this.licenseSubject;
    }

    public String getLicenseSubject() {
        return (String)this.licenseSubject.getValue();
    }

    public BooleanBinding validLicenseProperty() {
        return this.validLicenseProperty;
    }

    public boolean isValidLicense() {
        return this.validLicenseProperty.get();
    }
}

