/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import com.google.common.io.BaseEncoding;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
class LicenseChecker {
    private final JWTVerifier verifier;

    @Inject
    public LicenseChecker(@Named(value="licensePublicKey") String pemEncodedPublicKey) {
        Algorithm algorithm = Algorithm.ECDSA512((ECPublicKey)LicenseChecker.decodePublicKey(pemEncodedPublicKey), null);
        this.verifier = JWT.require((Algorithm)algorithm).build();
    }

    private static ECPublicKey decodePublicKey(String pemEncodedPublicKey) {
        try {
            byte[] keyBytes = BaseEncoding.base64().decode((CharSequence)pemEncodedPublicKey);
            PublicKey key = KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(keyBytes));
            if (key instanceof ECPublicKey) {
                ECPublicKey k = (ECPublicKey)key;
                return k;
            }
            throw new IllegalStateException("Key not an EC public key.");
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid license public key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public Optional<DecodedJWT> check(String licenseKey) {
        try {
            return Optional.of(this.verifier.verify(licenseKey));
        }
        catch (JWTVerificationException exception) {
            return Optional.empty();
        }
    }
}

