/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger LOG = LoggerFactory.getLogger(Environment.class);
    private static final int DEFAULT_MIN_PW_LENGTH = 8;
    private static final String SETTINGS_PATH_PROP_NAME = "cryptomator.settingsPath";
    private static final String IPC_SOCKET_PATH_PROP_NAME = "cryptomator.ipcSocketPath";
    private static final String KEYCHAIN_PATHS_PROP_NAME = "cryptomator.integrationsWin.keychainPaths";
    private static final String P12_PATH_PROP_NAME = "cryptomator.p12Path";
    private static final String LOG_DIR_PROP_NAME = "cryptomator.logDir";
    private static final String LOOPBACK_ALIAS_PROP_NAME = "cryptomator.loopbackAlias";
    private static final String MOUNTPOINT_DIR_PROP_NAME = "cryptomator.mountPointsDir";
    private static final String MIN_PW_LENGTH_PROP_NAME = "cryptomator.minPwLength";
    private static final String APP_VERSION_PROP_NAME = "cryptomator.appVersion";
    private static final String BUILD_NUMBER_PROP_NAME = "cryptomator.buildNumber";
    private static final String PLUGIN_DIR_PROP_NAME = "cryptomator.pluginDir";
    private static final String TRAY_ICON_PROP_NAME = "cryptomator.showTrayIcon";
    private static final String DISABLE_UPDATE_CHECK_PROP_NAME = "cryptomator.disableUpdateCheck";

    private Environment() {
    }

    public void log() {
        LOG.info("user.home: {}", (Object)System.getProperty("user.home"));
        LOG.info("java.library.path: {}", (Object)System.getProperty("java.library.path"));
        LOG.info("user.language: {}", (Object)System.getProperty("user.language"));
        LOG.info("user.region: {}", (Object)System.getProperty("user.region"));
        LOG.info("logback.configurationFile: {}", (Object)System.getProperty("logback.configurationFile"));
        this.logCryptomatorSystemProperty(SETTINGS_PATH_PROP_NAME);
        this.logCryptomatorSystemProperty(IPC_SOCKET_PATH_PROP_NAME);
        this.logCryptomatorSystemProperty(KEYCHAIN_PATHS_PROP_NAME);
        this.logCryptomatorSystemProperty(P12_PATH_PROP_NAME);
        this.logCryptomatorSystemProperty(LOG_DIR_PROP_NAME);
        this.logCryptomatorSystemProperty(LOOPBACK_ALIAS_PROP_NAME);
        this.logCryptomatorSystemProperty(MOUNTPOINT_DIR_PROP_NAME);
        this.logCryptomatorSystemProperty(MIN_PW_LENGTH_PROP_NAME);
        this.logCryptomatorSystemProperty(APP_VERSION_PROP_NAME);
        this.logCryptomatorSystemProperty(BUILD_NUMBER_PROP_NAME);
        this.logCryptomatorSystemProperty(PLUGIN_DIR_PROP_NAME);
        this.logCryptomatorSystemProperty(TRAY_ICON_PROP_NAME);
        this.logCryptomatorSystemProperty(DISABLE_UPDATE_CHECK_PROP_NAME);
    }

    public static Environment getInstance() {
        final class Holder {
            private static final Environment INSTANCE = new Environment();

            Holder() {
            }
        }
        return Holder.INSTANCE;
    }

    private void logCryptomatorSystemProperty(String propertyName) {
        LOG.info("{}: {}", (Object)propertyName, (Object)System.getProperty(propertyName));
    }

    public boolean useCustomLogbackConfig() {
        return this.getPath("logback.configurationFile").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false);
    }

    public Stream<Path> getSettingsPath() {
        return this.getPaths(SETTINGS_PATH_PROP_NAME);
    }

    public Stream<Path> getIpcSocketPath() {
        return this.getPaths(IPC_SOCKET_PATH_PROP_NAME);
    }

    public Stream<Path> getKeychainPath() {
        return this.getPaths(KEYCHAIN_PATHS_PROP_NAME);
    }

    public Stream<Path> getP12Path() {
        return this.getPaths(P12_PATH_PROP_NAME);
    }

    public Optional<Path> getLogDir() {
        return this.getPath(LOG_DIR_PROP_NAME);
    }

    public Optional<String> getLoopbackAlias() {
        return Optional.ofNullable(System.getProperty(LOOPBACK_ALIAS_PROP_NAME));
    }

    public Optional<Path> getMountPointsDir() {
        return this.getPath(MOUNTPOINT_DIR_PROP_NAME);
    }

    public int getMinPwLength() {
        return Integer.getInteger(MIN_PW_LENGTH_PROP_NAME, 8);
    }

    public String getAppVersion() {
        return System.getProperty(APP_VERSION_PROP_NAME, "SNAPSHOT");
    }

    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(System.getProperty(BUILD_NUMBER_PROP_NAME));
    }

    public Optional<Path> getPluginDir() {
        return this.getPath(PLUGIN_DIR_PROP_NAME);
    }

    public boolean showTrayIcon() {
        return Boolean.getBoolean(TRAY_ICON_PROP_NAME);
    }

    public boolean disableUpdateCheck() {
        return Boolean.getBoolean(DISABLE_UPDATE_CHECK_PROP_NAME);
    }

    private Optional<Path> getPath(String propertyName) {
        String value = System.getProperty(propertyName);
        return Optional.ofNullable(value).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    @VisibleForTesting
    Stream<Path> getPaths(String propertyName) {
        Stream<String> rawSettingsPaths = this.getRawList(propertyName, System.getProperty("path.separator").charAt(0));
        return rawSettingsPaths.filter(Predicate.not(Strings::isNullOrEmpty)).map(x$0 -> Path.of(x$0, new String[0]));
    }

    private Stream<String> getRawList(String propertyName, char separator) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            return Stream.empty();
        }
        Iterable iter = Splitter.on((char)separator).split((CharSequence)value);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iter.iterator(), 1040);
        return StreamSupport.stream(spliterator, false);
    }
}

