/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.uiappearance;

import java.util.ArrayList;
import java.util.Collection;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.uiappearance.Theme;
import org.cryptomator.integrations.uiappearance.UiAppearanceListener;
import org.cryptomator.integrations.uiappearance.UiAppearanceProvider;
import org.cryptomator.windows.uiappearance.WinAppearance;

@Priority(value=1000)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public class WinUiAppearanceProvider
implements UiAppearanceProvider {
    private final WinAppearance winAppearance = new WinAppearance();
    private final Collection<UiAppearanceListener> registeredListeners = new ArrayList<UiAppearanceListener>();
    private volatile Thread appearanceObserver;

    public Theme getSystemTheme() {
        return this.winAppearance.getSystemTheme();
    }

    public void adjustToTheme(Theme theme) {
    }

    public synchronized void addListener(UiAppearanceListener listener) {
        boolean wasEmpty = this.registeredListeners.isEmpty();
        this.registeredListeners.add(listener);
        if (wasEmpty) {
            assert (this.appearanceObserver == null);
            this.appearanceObserver = this.winAppearance.startObserving(this::systemAppearanceChanged);
        }
    }

    public synchronized void removeListener(UiAppearanceListener listener) {
        this.registeredListeners.remove(listener);
        if (this.appearanceObserver != null && this.registeredListeners.isEmpty()) {
            this.appearanceObserver.interrupt();
            this.appearanceObserver = null;
        }
    }

    private void systemAppearanceChanged(Theme theme) {
        for (UiAppearanceListener listener : this.registeredListeners) {
            listener.systemAppearanceChanged(theme);
        }
    }
}

