/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.uiappearance;

import java.util.function.Consumer;
import org.cryptomator.integrations.uiappearance.Theme;
import org.cryptomator.windows.common.NativeLibLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WinAppearance {
    private static final Logger LOG = LoggerFactory.getLogger(WinAppearance.class);
    private static final Theme DEFAULT_THEME = Theme.LIGHT;

    WinAppearance() {
    }

    public Theme getSystemTheme() {
        try {
            return this.getSystemThemeInternal();
        }
        catch (IllegalStateException e) {
            LOG.warn("Failed to determine system theme", (Throwable)e);
            return DEFAULT_THEME;
        }
    }

    private Theme getSystemThemeInternal() throws IllegalStateException {
        switch (Native.INSTANCE.getCurrentTheme()) {
            case 0: {
                return Theme.DARK;
            }
            case 1: {
                return Theme.LIGHT;
            }
        }
        return DEFAULT_THEME;
    }

    public Thread startObserving(Consumer<Theme> listener) {
        Thread observer = new Thread(() -> {
            try {
                this.notifyOnThemeChange(listener);
            }
            catch (IllegalStateException e) {
                LOG.warn("Failed to observe system theme", (Throwable)e);
            }
        }, "AppearanceObserver");
        observer.setDaemon(true);
        observer.start();
        return observer;
    }

    private void notifyOnThemeChange(Consumer<Theme> listener) throws IllegalStateException {
        Theme currentTheme = this.getSystemThemeInternal();
        while (!Thread.interrupted()) {
            Native.INSTANCE.waitForNextThemeChange();
            Theme newTheme = this.getSystemThemeInternal();
            if (newTheme == currentTheme) continue;
            listener.accept(newTheme);
            currentTheme = newTheme;
        }
    }

    private static class Native {
        static final Native INSTANCE = new Native();

        private Native() {
            NativeLibLoader.loadLib();
        }

        public native int getCurrentTheme() throws IllegalStateException;

        public native void waitForNextThemeChange() throws IllegalStateException;
    }
}

