/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.common;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.charset.StandardCharsets;
import org.cryptomator.windows.capi.common.Windows_h;
import org.cryptomator.windows.capi.ktmw32.Ktmw32_h;
import org.cryptomator.windows.capi.winreg.Winreg_h;
import org.cryptomator.windows.common.RegistryKey;
import org.cryptomator.windows.common.RegistryKeyException;
import org.cryptomator.windows.common.WindowsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsRegistry.class);

    public static RegistryTransaction startTransaction() throws WindowsException {
        MemorySegment transactionHandle = Ktmw32_h.CreateTransaction(MemorySegment.NULL, MemorySegment.NULL, 0, 0, 0, 0, MemorySegment.NULL);
        if (transactionHandle.address() == Windows_h.INVALID_HANDLE_VALUE().address()) {
            int error = Windows_h.GetLastError();
            throw new WindowsException("ktmw32.h:CreateTransaction", error);
        }
        return new RegistryTransaction(transactionHandle);
    }

    public static class RegistryTransaction
    implements AutoCloseable {
        private MemorySegment transactionHandle;
        private volatile boolean isCommited = false;
        private volatile boolean isClosed = false;

        RegistryTransaction(MemorySegment handle) {
            this.transactionHandle = handle;
        }

        public RegistryKey createRegKey(RegistryKey key, String subkey, boolean isVolatile) throws RegistryKeyException {
            MemorySegment pointerToResultKey = Arena.ofAuto().allocate(AddressLayout.ADDRESS);
            try (Arena arena = Arena.ofConfined();){
                MemorySegment lpSubkey = arena.allocateFrom(subkey, StandardCharsets.UTF_16LE);
                int result = Winreg_h.RegCreateKeyTransactedW(key.getHandle(), lpSubkey, 0, MemorySegment.NULL, isVolatile ? Winreg_h.REG_OPTION_VOLATILE() : Winreg_h.REG_OPTION_NON_VOLATILE(), Winreg_h.KEY_READ() | Winreg_h.KEY_WRITE(), MemorySegment.NULL, pointerToResultKey, MemorySegment.NULL, this.transactionHandle, MemorySegment.NULL);
                if (result != Windows_h.ERROR_SUCCESS()) {
                    throw new RegistryKeyException("winreg.h:RegCreateKeyTransactedW", key.getPath() + "\\" + subkey, result);
                }
                RegistryKey registryKey = new RegistryKey(pointerToResultKey.get(Winreg_h.C_POINTER, 0L), key.getPath() + "\\" + subkey);
                return registryKey;
            }
        }

        public RegistryKey openRegKey(RegistryKey key, String subkey) throws RegistryKeyException {
            MemorySegment pointerToResultKey = Arena.ofAuto().allocate(AddressLayout.ADDRESS);
            try (Arena arena = Arena.ofConfined();){
                MemorySegment lpSubkey = arena.allocateFrom(subkey, StandardCharsets.UTF_16LE);
                int result = Winreg_h.RegOpenKeyTransactedW(key.getHandle(), lpSubkey, 0, Winreg_h.KEY_READ() | Winreg_h.KEY_WRITE(), pointerToResultKey, this.transactionHandle, MemorySegment.NULL);
                if (result != Windows_h.ERROR_SUCCESS()) {
                    throw new RegistryKeyException("winreg.h:RegOpenKeyTransactedW", key.getPath() + "\\" + subkey, result);
                }
                RegistryKey registryKey = new RegistryKey(pointerToResultKey.get(Winreg_h.C_POINTER, 0L), key.getPath() + "\\" + subkey);
                return registryKey;
            }
        }

        public void deleteRegKey(RegistryKey key, String subkey) throws RegistryKeyException {
            this.deleteRegKey(key, subkey, false);
        }

        public void deleteRegKey(RegistryKey key, String subkey, boolean ignoreNotExisting) throws RegistryKeyException {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment lpSubkey = arena.allocateFrom(subkey, StandardCharsets.UTF_16LE);
                int result = Winreg_h.RegDeleteKeyTransactedW(key.getHandle(), lpSubkey, 256, 0, this.transactionHandle, MemorySegment.NULL);
                if (!(result == Windows_h.ERROR_SUCCESS() || result == Windows_h.ERROR_FILE_NOT_FOUND() && ignoreNotExisting)) {
                    throw new RegistryKeyException("winreg.h:RegDeleteKeyTransactedW", key.getPath() + "\\" + subkey, result);
                }
            }
        }

        public synchronized void commit() throws WindowsException {
            if (this.isClosed) {
                throw new IllegalStateException("Transaction already closed");
            }
            int result = Ktmw32_h.CommitTransaction(this.transactionHandle);
            if (result == 0) {
                int error = Windows_h.GetLastError();
                throw new WindowsException("ktmw32.h:CommitTransaction", error);
            }
            this.isCommited = true;
            this.closeInternal();
        }

        public synchronized void rollback() throws WindowsException {
            if (this.isClosed) {
                throw new IllegalStateException("Transaction already closed");
            }
            int result = Ktmw32_h.RollbackTransaction(this.transactionHandle);
            if (result == 0) {
                int error = Windows_h.GetLastError();
                throw new WindowsException("ktmw32.h:CommitTransaction", error);
            }
            this.closeInternal();
        }

        @Override
        public synchronized void close() {
            try {
                if (!this.isCommited) {
                    this.rollback();
                }
            }
            catch (WindowsException e) {
                LOG.error("Failed to rollback uncommited transaction on close: {}", (Object)e.getMessage());
            }
            finally {
                this.closeInternal();
            }
        }

        private synchronized void closeInternal() {
            if (!this.isClosed) {
                int result = Windows_h.CloseHandle(this.transactionHandle);
                if (result == 0) {
                    int error = Windows_h.GetLastError();
                    LOG.error("Closing transaction handle failed. Function Windows.h:CloseHandle set system error code to {}", (Object)error);
                }
                this.transactionHandle = null;
                this.isClosed = true;
            }
        }
    }
}

