/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.capi.ktmw32;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class Ktmw32_h {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("KtmW32"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfDouble C_LONG_DOUBLE = ValueLayout.JAVA_DOUBLE;
    private static final MemorySegment INVALID_HANDLE_VALUE = MemorySegment.ofAddress(-1L);

    Ktmw32_h() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> Ktmw32_h.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), Ktmw32_h.align(s.elementLayout(), align));
            }
        };
    }

    public static FunctionDescriptor CreateTransaction$descriptor() {
        return CreateTransaction.DESC;
    }

    public static MethodHandle CreateTransaction$handle() {
        return CreateTransaction.HANDLE;
    }

    public static MemorySegment CreateTransaction$address() {
        return CreateTransaction.ADDR;
    }

    public static MemorySegment CreateTransaction(MemorySegment lpTransactionAttributes, MemorySegment UOW, int CreateOptions, int IsolationLevel, int IsolationFlags, int Timeout, MemorySegment Description) {
        MethodHandle mh$ = CreateTransaction.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Ktmw32_h.traceDowncall("CreateTransaction", lpTransactionAttributes, UOW, CreateOptions, IsolationLevel, IsolationFlags, Timeout, Description);
            }
            return mh$.invokeExact(lpTransactionAttributes, UOW, CreateOptions, IsolationLevel, IsolationFlags, Timeout, Description);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor CommitTransaction$descriptor() {
        return CommitTransaction.DESC;
    }

    public static MethodHandle CommitTransaction$handle() {
        return CommitTransaction.HANDLE;
    }

    public static MemorySegment CommitTransaction$address() {
        return CommitTransaction.ADDR;
    }

    public static int CommitTransaction(MemorySegment TransactionHandle) {
        MethodHandle mh$ = CommitTransaction.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Ktmw32_h.traceDowncall("CommitTransaction", TransactionHandle);
            }
            return mh$.invokeExact(TransactionHandle);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor RollbackTransaction$descriptor() {
        return RollbackTransaction.DESC;
    }

    public static MethodHandle RollbackTransaction$handle() {
        return RollbackTransaction.HANDLE;
    }

    public static MemorySegment RollbackTransaction$address() {
        return RollbackTransaction.ADDR;
    }

    public static int RollbackTransaction(MemorySegment TransactionHandle) {
        MethodHandle mh$ = RollbackTransaction.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Ktmw32_h.traceDowncall("RollbackTransaction", TransactionHandle);
            }
            return mh$.invokeExact(TransactionHandle);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment INVALID_HANDLE_VALUE() {
        return INVALID_HANDLE_VALUE;
    }

    private static class CreateTransaction {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_POINTER, C_POINTER, C_POINTER, C_LONG, C_LONG, C_LONG, C_LONG, C_POINTER);
        public static final MemorySegment ADDR = Ktmw32_h.findOrThrow("CreateTransaction");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private CreateTransaction() {
        }
    }

    private static class CommitTransaction {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = Ktmw32_h.findOrThrow("CommitTransaction");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private CommitTransaction() {
        }
    }

    private static class RollbackTransaction {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = Ktmw32_h.findOrThrow("RollbackTransaction");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private RollbackTransaction() {
        }
    }
}

