/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.autostart;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.cryptomator.integrations.autostart.AutoStartProvider;
import org.cryptomator.integrations.autostart.ToggleAutoStartFailedException;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.windows.autostart.WinShellLinks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public class WindowsAutoStart
implements AutoStartProvider {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsAutoStart.class);
    private static final String LNK_FILE_EXTENSION = ".lnk";
    private static final String LNK_NAME_PROPERTY = "cryptomator.integrationsWin.autoStartShellLinkName";
    private final WinShellLinks winShellLinks = new WinShellLinks();
    private final Optional<String> shellLinkName;
    private final Optional<Path> absShellLinkPath;
    private final Optional<Path> exePath = ProcessHandle.current().info().command().map(x$0 -> Path.of(x$0, new String[0]));

    public WindowsAutoStart() {
        this.shellLinkName = Optional.ofNullable(System.getProperty(LNK_NAME_PROPERTY)).or(() -> this.exePath.map(this::getExeBaseName));
        this.absShellLinkPath = Optional.ofNullable(this.winShellLinks.getPathToStartupFolder()).flatMap(p -> this.shellLinkName.map(name -> p + "\\" + name + LNK_FILE_EXTENSION)).map(x$0 -> Path.of(x$0, new String[0]));
    }

    public boolean isEnabled() {
        return this.absShellLinkPath.map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false);
    }

    public synchronized void enable() throws ToggleAutoStartFailedException {
        if (this.exePath.isEmpty()) {
            throw new ToggleAutoStartFailedException("Enabling autostart using the startup folder failed: Path to executable is not set");
        }
        assert (this.exePath.isPresent() && this.absShellLinkPath.isPresent() && this.shellLinkName.isPresent());
        int returnCode = this.winShellLinks.createShortcut(this.exePath.get().toString(), this.absShellLinkPath.get().toString(), this.shellLinkName.get());
        if (returnCode != 0) {
            throw new ToggleAutoStartFailedException("Enabling autostart using the startup folder failed. Windows error code: " + Integer.toHexString(returnCode));
        }
        LOG.debug("Successfully created {}.", (Object)this.absShellLinkPath.get());
    }

    public synchronized void disable() throws ToggleAutoStartFailedException {
        try {
            Files.delete(this.absShellLinkPath.get());
            LOG.debug("Successfully deleted {}.", (Object)this.absShellLinkPath.get());
        }
        catch (NoSuchElementException e) {
            throw new ToggleAutoStartFailedException("Disabling auto start failed using startup folder: Name of shell link is not defined.");
        }
        catch (NoSuchFileException e) {
            LOG.debug("File {} not present. Nothing to do.", (Object)this.absShellLinkPath.get());
        }
        catch (IOException e) {
            LOG.debug("Failed to delete entry from auto start folder.", (Throwable)e);
            throw new ToggleAutoStartFailedException("Disabling auto start failed using startup folder.", (Throwable)e);
        }
    }

    private String getExeBaseName(Path exePath) {
        String name = exePath.getFileName().toString();
        if (name.lastIndexOf(46) != -1) {
            return name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }
}

