/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonMappingsTableCellEditor
extends AbstractTableCellEditor {
    final TextFieldWithBrowseButton myComponent;
    final JPanel myWrapper;
    private final UserDefinedJsonSchemaConfiguration.Item myItem;
    private final Project myProject;
    private final TreeUpdater myTreeUpdater;

    JsonMappingsTableCellEditor(UserDefinedJsonSchemaConfiguration.Item item, Project project, TreeUpdater treeUpdater) {
        this.myItem = item;
        this.myProject = project;
        this.myTreeUpdater = treeUpdater;
        this.myComponent = new TextFieldWithBrowseButton(){

            protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, Disposable parent) {
            }
        };
        this.myWrapper = new JPanel();
        this.myWrapper.setBorder((Border)JBUI.Borders.empty((int)-3, (int)0));
        this.myWrapper.setLayout(new BorderLayout());
        JLabel label = new JLabel(item.mappingKind.getPrefix().trim(), item.mappingKind.getIcon(), 2);
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)1));
        this.myWrapper.add((Component)label, "Before");
        this.myWrapper.add((Component)this.myComponent, "Center");
        FileChooserDescriptor descriptor = JsonMappingsTableCellEditor.createDescriptor(item);
        if (item.isPattern()) {
            this.myComponent.getButton().setVisible(false);
        } else {
            this.myComponent.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, this.myProject){

                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)chosenFile, (VirtualFile)JsonMappingsTableCellEditor.this.myProject.getBaseDir());
                    return relativePath != null ? relativePath : chosenFile.getPath();
                }
            });
        }
        MyFileTextFieldImpl field = null;
        if (!(item.isPattern() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
            LocalFsFinder finder = new LocalFsFinder();
            finder.setBaseDir(new File(this.myProject.getBaseDir().getPath()));
            field = new MyFileTextFieldImpl(finder, descriptor, this.myComponent.getTextField(), this.myProject, (Disposable)this.myComponent);
        }
        final MyFileTextFieldImpl finalField = field;
        this.myComponent.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(e.getKeyCode() != 10 || finalField != null && finalField.isPopupDisplayed())) {
                    JsonMappingsTableCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    @NotNull
    private static FileChooserDescriptor createDescriptor(UserDefinedJsonSchemaConfiguration.Item item) {
        return item.mappingKind == JsonMappingKind.File ? FileChooserDescriptorFactory.createSingleFileDescriptor() : FileChooserDescriptorFactory.createSingleFolderDescriptor();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JTextField)this.myComponent.getChildComponent()).setText(this.myItem.getPath());
        return this.myWrapper;
    }

    public boolean stopCellEditing() {
        this.myItem.setPath(((JTextField)this.myComponent.getChildComponent()).getText());
        this.myTreeUpdater.updateTree(true);
        return super.stopCellEditing();
    }

    public Object getCellEditorValue() {
        return ((JTextField)this.myComponent.getChildComponent()).getText();
    }

    private static class MyFileTextFieldImpl
    extends FileTextFieldImpl {
        private final JTextField myTextField;
        private final Project myProject;

        MyFileTextFieldImpl(LocalFsFinder finder, FileChooserDescriptor descriptor, JTextField textField, Project project, Disposable parent) {
            super(textField, (FileLookup.Finder)finder, (FileLookup.LookupFilter)new LocalFsFinder.FileChooserFilter(descriptor, true), FileChooserFactoryImpl.getMacroMap(), parent);
            this.myTextField = textField;
            this.myProject = project;
            this.myAutopopup = true;
        }

        @Nullable
        public VirtualFile getSelectedFile() {
            FileLookup.LookupFile lookupFile = this.getFile();
            return lookupFile != null ? ((LocalFsFinder.VfsFile)lookupFile).getFile() : null;
        }

        protected void setTextToFile(FileLookup.LookupFile file) {
            String path = file.getAbsolutePath();
            VirtualFile ioFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            if (ioFile == null) {
                this.myTextField.setText(path);
                return;
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)ioFile, (VirtualFile)this.myProject.getBaseDir());
            this.myTextField.setText(relativePath != null ? relativePath : path);
        }
    }
}

