/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRemoteContentProvider
extends DefaultRemoteContentProvider {
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final long UPDATE_DELAY = Duration.ofHours(4L).toMillis();
    static final String STORE_URL_PREFIX_HTTP = "http://json.schemastore.org";
    static final String STORE_URL_PREFIX_HTTPS = "https://schemastore.azurewebsites.net";
    private static final String SCHEMA_URL_PREFIX = "http://json-schema.org/";
    private static final String SCHEMA_URL_PREFIX_HTTPS = "https://json-schema.org/";
    private static final String ETAG_HEADER = "ETag";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private long myLastUpdateTime = 0L;

    public boolean canProvideContent(@NotNull Url url) {
        String externalForm = url.toExternalForm();
        return externalForm.startsWith(STORE_URL_PREFIX_HTTP) || externalForm.startsWith(STORE_URL_PREFIX_HTTPS) || externalForm.startsWith(SCHEMA_URL_PREFIX) || externalForm.startsWith(SCHEMA_URL_PREFIX_HTTPS) || externalForm.endsWith(".json");
    }

    protected void saveAdditionalData(@NotNull HttpRequests.Request request, @NotNull File file) throws IOException {
        URLConnection connection = request.getConnection();
        if (JsonSchemaRemoteContentProvider.saveTag(file, connection, ETAG_HEADER)) {
            return;
        }
        JsonSchemaRemoteContentProvider.saveTag(file, connection, LAST_MODIFIED_HEADER);
    }

    @Nullable
    protected FileType adjustFileType(@Nullable FileType type, @NotNull Url url) {
        String fullUrl;
        if (type == null && ((fullUrl = url.toExternalForm()).startsWith(SCHEMA_URL_PREFIX) || fullUrl.startsWith(SCHEMA_URL_PREFIX_HTTPS))) {
            return JsonFileType.INSTANCE;
        }
        return super.adjustFileType(type, url);
    }

    private static boolean saveTag(@NotNull File file, @NotNull URLConnection connection, @NotNull String header) throws IOException {
        String tag = connection.getHeaderField(header);
        if (tag != null) {
            String path = file.getAbsolutePath();
            if (!path.endsWith(".json")) {
                path = path + ".json";
            }
            File tagFile = new File(path + "." + header);
            JsonSchemaRemoteContentProvider.saveToFile(tagFile, tag);
            return true;
        }
        return false;
    }

    private static void saveToFile(@NotNull File tagFile, @NotNull String headerValue) throws IOException {
        if (!tagFile.exists() && !tagFile.createNewFile()) {
            return;
        }
        Files.write(tagFile.toPath(), (Iterable<? extends CharSequence>)ContainerUtil.createMaybeSingletonList((Object)headerValue), new OpenOption[0]);
    }

    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        long now = System.currentTimeMillis();
        if (now - this.myLastUpdateTime < UPDATE_DELAY) {
            return true;
        }
        this.myLastUpdateTime = now;
        String path = local.getPath();
        if (now - new File(path).lastModified() < UPDATE_DELAY) {
            return true;
        }
        if (this.checkUpToDate(url, path, ETAG_HEADER)) {
            return true;
        }
        return this.checkUpToDate(url, path, LAST_MODIFIED_HEADER);
    }

    private boolean checkUpToDate(@NotNull Url url, @NotNull String path, @NotNull String header) {
        File file = new File(path + "." + header);
        try {
            return this.isUpToDate(url, file, header);
        }
        catch (IOException e) {
            new File(path).setLastModified(System.currentTimeMillis());
            return true;
        }
    }

    protected int getDefaultConnectionTimeout() {
        return 10000;
    }

    private boolean isUpToDate(@NotNull Url url, @NotNull File file, @NotNull String header) throws IOException {
        String currentTag;
        List<String> strings = file.exists() ? Files.readAllLines(file.toPath()) : ContainerUtil.emptyList();
        String string = currentTag = strings.size() > 0 ? strings.get(0) : null;
        if (currentTag == null) {
            return false;
        }
        String remoteTag = (String)this.connect(url, HttpRequests.head((String)url.toExternalForm()), r -> r.getConnection().getHeaderField(header));
        return currentTag.equals(remoteTag);
    }
}

