/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.breadcrumbs;

import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonUtil;
import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.navigation.JsonQualifiedNameProvider;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.Language;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBreadcrumbsProvider
implements BreadcrumbsProvider {
    private static final Language[] LANGUAGES = new Language[]{JsonLanguage.INSTANCE};

    public Language[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof JsonProperty || JsonUtil.isArrayElement(e);
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        int i;
        if (e instanceof JsonProperty) {
            return ((JsonProperty)e).getName();
        }
        if (JsonUtil.isArrayElement(e) && (i = JsonUtil.getArrayIndexOfItem(e)) != -1) {
            return String.valueOf(i);
        }
        throw new AssertionError((Object)"Breadcrumbs can be extracted only from JsonProperty elements or JsonArray child items");
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(e, null, true, null);
    }

    @NotNull
    public List<? extends Action> getContextActions(final @NotNull PsiElement element) {
        JsonQualifiedNameKind[] values = JsonQualifiedNameKind.values();
        ArrayList<1> actions = new ArrayList<1>(values.length);
        for (final JsonQualifiedNameKind kind : values) {
            actions.add(new AbstractAction(JsonBundle.message("json.copy.to.clipboard", kind.toString())){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(JsonQualifiedNameProvider.generateQualifiedName(element, kind)));
                }
            });
        }
        return actions;
    }
}

