/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JsonStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonStringLiteral>(){

        public void tokenize(@NotNull JsonStringLiteral element, TokenConsumer consumer) {
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element.textContains('\\')) {
                List<Pair<TextRange, String>> fragments = element.getTextFragments();
                for (Pair<TextRange, String> fragment : fragments) {
                    TextRange fragmentRange = (TextRange)fragment.getFirst();
                    String escaped = (String)fragment.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer.consumeToken((PsiElement)element, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), (Splitter)textSplitter);
                }
            } else {
                consumer.consumeToken((PsiElement)element, (Splitter)textSplitter);
            }
        }
    };

    private static boolean matchesNameFromSchema(@NotNull JsonStringLiteral element) {
        String value;
        JsonProperty property;
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null) {
            return false;
        }
        Project project = element.getProject();
        JsonSchemaService service = JsonSchemaService.Impl.get(project);
        if (!service.isApplicableToFile(file)) {
            return false;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(element.getContainingFile());
        if (rootSchema == null) {
            return false;
        }
        if (service.isSchemaFile(rootSchema) && (property = (JsonProperty)ObjectUtils.tryCast((Object)element.getParent(), JsonProperty.class)) != null) {
            PsiElement grandParent;
            PsiElement parent;
            if ("x-intellij-language-injection".equals(property.getName())) {
                return true;
            }
            if ("language".equals(property.getName()) && (parent = property.getParent()) instanceof JsonObject && (grandParent = parent.getParent()) instanceof JsonProperty && "x-intellij-language-injection".equals(((JsonProperty)grandParent).getName())) {
                return true;
            }
        }
        if (StringUtil.isEmpty((String)(value = element.getValue()))) {
            return false;
        }
        JsonOriginalPsiWalker walker = JsonOriginalPsiWalker.INSTANCE;
        PsiElement checkable = walker.findElementToCheck(element);
        if (checkable == null) {
            return false;
        }
        ThreeState isName = walker.isName(checkable);
        JsonPointerPosition position = walker.findPosition(checkable, isName == ThreeState.NO);
        if (position == null || position.isEmpty() && isName == ThreeState.NO) {
            return false;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(project, rootSchema, position).resolve();
        if (schemas.isEmpty()) {
            return false;
        }
        return schemas.stream().anyMatch(s -> s.getProperties().containsKey(value) || s.getMatchingPatternPropertySchema(value) != null);
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof JsonStringLiteral) {
            return JsonSpellcheckerStrategy.matchesNameFromSchema((JsonStringLiteral)element) ? EMPTY_TOKENIZER : this.ourStringLiteralTokenizer;
        }
        return super.getTokenizer(element);
    }
}

