/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GradleSystemSettings", storages={@Storage(value="gradle.settings.xml")})
public class GradleSystemSettings
implements PersistentStateComponent<MyState> {
    @Nullable
    private String myServiceDirectoryPath;
    @Nullable
    private String myGradleVmOptions;

    @NotNull
    public static GradleSystemSettings getInstance() {
        return (GradleSystemSettings)ServiceManager.getService(GradleSystemSettings.class);
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        state.serviceDirectoryPath = this.myServiceDirectoryPath;
        state.gradleVmOptions = this.myGradleVmOptions;
        return state;
    }

    public void loadState(@NotNull MyState state) {
        this.myServiceDirectoryPath = state.serviceDirectoryPath;
        this.myGradleVmOptions = state.gradleVmOptions;
    }

    @Nullable
    public String getServiceDirectoryPath() {
        return this.myServiceDirectoryPath;
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        this.myServiceDirectoryPath = newPath;
    }

    @Nullable
    public String getGradleVmOptions() {
        return this.myGradleVmOptions;
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        this.myGradleVmOptions = gradleVmOptions;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isOfflineWork() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setOfflineWork(boolean isOfflineWork) {
    }

    public static class MyState {
        public String serviceDirectoryPath;
        public String gradleVmOptions;
        @Transient
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public boolean offlineWork;
    }
}

