/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.FileNavigationLogger;
import com.intellij.filePrediction.predictor.FilePredictionCandidate;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002JB\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J>\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012J8\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/filePrediction/FileUsagePredictionLogger;", "", "logTopLimit", "", "logTotalLimit", "(II)V", "isRecentCandidate", "", "candidate", "Lcom/intellij/filePrediction/predictor/FilePredictionCandidate;", "logCalculatedCandidate", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "prevPath", "", "totalDuration", "", "refsComputation", "opened", "logNotOpenedCandidates", "candidates", "", "total", "refs", "logOpenedFile", "intellij.filePrediction"})
public final class FileUsagePredictionLogger {
    private final int logTopLimit;
    private final int logTotalLimit;

    public final void logOpenedFile(@NotNull Project project, int sessionId, @Nullable String prevPath, @NotNull FilePredictionCandidate candidate, long total, long refs) {
        this.logCalculatedCandidate(project, sessionId, prevPath, candidate, total, refs, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void logNotOpenedCandidates(@NotNull Project project, int sessionId, @Nullable String prevPath, @NotNull List<FilePredictionCandidate> candidates, long total, long refs) {
        void $this$filterTo$iv$iv;
        List head = CollectionsKt.take((Iterable)candidates, (int)this.logTopLimit);
        for (FilePredictionCandidate candidate : head) {
            this.logCalculatedCandidate(project, sessionId, prevPath, candidate, total, refs, false);
        }
        Iterable $this$filter$iv = head;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilePredictionCandidate it = (FilePredictionCandidate)element$iv$iv;
            boolean bl = false;
            if (!this.isRecentCandidate(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        int numOfRecentCandidates = $this$filter$iv.size();
        if (candidates.size() > this.logTopLimit) {
            List tail = candidates.subList(this.logTopLimit, candidates.size());
            if (numOfRecentCandidates > this.logTopLimit / 2) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = tail;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    FilePredictionCandidate it = (FilePredictionCandidate)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.isRecentCandidate(it))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                tail = (List)destination$iv$iv2;
            }
            List randomToLog = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)tail), (int)(this.logTotalLimit - this.logTopLimit));
            for (FilePredictionCandidate candidate : randomToLog) {
                this.logCalculatedCandidate(project, sessionId, prevPath, candidate, total, refs, false);
            }
        }
    }

    private final boolean isRecentCandidate(FilePredictionCandidate candidate) {
        return Intrinsics.areEqual((Object)candidate.getSource(), (Object)"open") || Intrinsics.areEqual((Object)candidate.getSource(), (Object)"recent");
    }

    private final void logCalculatedCandidate(Project project, int sessionId, String prevPath, FilePredictionCandidate candidate, long totalDuration, long refsComputation, boolean opened) {
        FileNavigationLogger.INSTANCE.logEvent(project, sessionId, candidate.getFeatures(), candidate.getPath(), prevPath, candidate.getSource(), opened, totalDuration, candidate.getFeaturesComputation(), refsComputation, candidate.getDuration(), candidate.getProbability());
    }

    public FileUsagePredictionLogger(int logTopLimit, int logTotalLimit) {
        this.logTopLimit = logTopLimit;
        this.logTotalLimit = logTotalLimit;
    }
}

