/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListUpdatesChecker;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.search.GHPRSearchQueryHolder;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u00070\u0001\u00a2\u0006\u0002\b%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "Lcom/intellij/openapi/Disposable;", "parsedRepositoryCoordinates", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "gitRemoteCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "searchHolder", "Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchQueryHolder;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "listUpdatesChecker", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "dataProviderRepository", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchQueryHolder;Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;)V", "getAvatarIconsProviderFactory", "()Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "getDataProviderRepository", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "getFilesManager", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "getGitRemoteCoordinates", "()Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "getListLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "getListUpdatesChecker", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "listenersDisposable", "Lorg/jetbrains/annotations/NotNull;", "getParsedRepositoryCoordinates", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRepositoryDataService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "getSearchHolder", "()Lorg/jetbrains/plugins/github/pullrequest/search/GHPRSearchQueryHolder;", "getSecurityService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "dispose", "", "intellij.vcs.github"})
public final class GHPRDataContext
implements Disposable {
    private final Disposable listenersDisposable;
    @NotNull
    private final GHRepositoryCoordinates parsedRepositoryCoordinates;
    @NotNull
    private final GitRemoteUrlCoordinates gitRemoteCoordinates;
    @NotNull
    private final GHPRSearchQueryHolder searchHolder;
    @NotNull
    private final GHListLoader<GHPullRequestShort> listLoader;
    @NotNull
    private final GHPRListUpdatesChecker listUpdatesChecker;
    @NotNull
    private final GHPRDataProviderRepository dataProviderRepository;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory;
    @NotNull
    private final GHPRFilesManager filesManager;

    public void dispose() {
        Disposer.dispose((Disposable)this.filesManager);
        Disposer.dispose((Disposable)this.listenersDisposable);
        Disposer.dispose((Disposable)this.dataProviderRepository);
        Disposer.dispose((Disposable)this.listLoader);
        Disposer.dispose((Disposable)this.listUpdatesChecker);
        Disposer.dispose((Disposable)this.repositoryDataService);
    }

    @NotNull
    public final GHRepositoryCoordinates getParsedRepositoryCoordinates() {
        return this.parsedRepositoryCoordinates;
    }

    @NotNull
    public final GitRemoteUrlCoordinates getGitRemoteCoordinates() {
        return this.gitRemoteCoordinates;
    }

    @NotNull
    public final GHPRSearchQueryHolder getSearchHolder() {
        return this.searchHolder;
    }

    @NotNull
    public final GHListLoader<GHPullRequestShort> getListLoader() {
        return this.listLoader;
    }

    @NotNull
    public final GHPRListUpdatesChecker getListUpdatesChecker() {
        return this.listUpdatesChecker;
    }

    @NotNull
    public final GHPRDataProviderRepository getDataProviderRepository() {
        return this.dataProviderRepository;
    }

    @NotNull
    public final GHPRSecurityService getSecurityService() {
        return this.securityService;
    }

    @NotNull
    public final GHPRRepositoryDataService getRepositoryDataService() {
        return this.repositoryDataService;
    }

    @NotNull
    public final CachingGithubAvatarIconsProvider.Factory getAvatarIconsProviderFactory() {
        return this.avatarIconsProviderFactory;
    }

    @NotNull
    public final GHPRFilesManager getFilesManager() {
        return this.filesManager;
    }

    public GHPRDataContext(@NotNull GHRepositoryCoordinates parsedRepositoryCoordinates, @NotNull GitRemoteUrlCoordinates gitRemoteCoordinates, @NotNull GHPRSearchQueryHolder searchHolder, @NotNull GHListLoader<GHPullRequestShort> listLoader2, @NotNull GHPRListUpdatesChecker listUpdatesChecker, @NotNull GHPRDataProviderRepository dataProviderRepository2, @NotNull GHPRSecurityService securityService, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull GHPRFilesManager filesManager) {
        this.parsedRepositoryCoordinates = parsedRepositoryCoordinates;
        this.gitRemoteCoordinates = gitRemoteCoordinates;
        this.searchHolder = searchHolder;
        this.listLoader = listLoader2;
        this.listUpdatesChecker = listUpdatesChecker;
        this.dataProviderRepository = dataProviderRepository2;
        this.securityService = securityService;
        this.repositoryDataService = repositoryDataService;
        this.avatarIconsProviderFactory = avatarIconsProviderFactory;
        this.filesManager = filesManager;
        this.listenersDisposable = Disposer.newDisposable((String)"GH PR context listeners disposable");
        this.searchHolder.addQueryChangeListener(this.listenersDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.getListLoader().reset();
            }
        }));
        this.listLoader.addDataListener(this.listenersDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                this.getListUpdatesChecker().start();
            }

            @Override
            public void onAllDataRemoved() {
                this.getListUpdatesChecker().stop();
            }

            @Override
            public void onDataUpdated(int idx) {
                GHListLoader.ListDataListener.DefaultImpls.onDataUpdated(this, idx);
            }

            @Override
            public void onDataRemoved(@NotNull Object data) {
                GHListLoader.ListDataListener.DefaultImpls.onDataRemoved(this, data);
            }
        });
        this.dataProviderRepository.addDetailsLoadedListener(this.listenersDisposable, (Function1<? super GHPullRequest, Unit>)((Function1)new Function1<GHPullRequest, Unit>(){

            public final void invoke(@NotNull GHPullRequest details2) {
                this.getListLoader().updateData(details2);
                this.getFilesManager().updateTimelineFilePresentation(details2);
            }
        }));
        this.filesManager.addBeforeTimelineFileOpenedListener(this.listenersDisposable, (Function1<? super GHPRTimelineVirtualFile, Unit>)((Function1)new Function1<GHPRTimelineVirtualFile, Unit>(){

            public final void invoke(@NotNull GHPRTimelineVirtualFile file) {
                GHPullRequestShort details2;
                GHPullRequestShort gHPullRequestShort;
                Object v0;
                block3: {
                    Iterable iterable = this.getListLoader().getLoadedData();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        GHPullRequestShort it = (GHPullRequestShort)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)file.getPullRequest().getId())) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                if ((gHPullRequestShort = (GHPullRequestShort)v0) == null) {
                    Object object = this.getDataProviderRepository().findDataProvider(file.getPullRequest());
                    gHPullRequestShort = details2 = (GHPullRequestShort)(object != null && (object = object.getDetailsData()) != null ? object.getLoadedDetails() : null);
                }
                if (details2 != null) {
                    this.getFilesManager().updateTimelineFilePresentation(details2);
                }
            }
        }));
    }
}

