/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.SimpleGHPRIdentifier;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "()V", "extractPresentableUrl", "", "Lorg/jetbrains/annotations/NotNull;", "path", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProtocol", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "Path", "intellij.vcs.github"})
public final class GHPRVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private static final String PROTOCOL = "ghpr";
    private static final Logger LOG;
    private static final ObjectMapper JACKSON;
    public static final Companion Companion;

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Path path2;
        try {
            path2 = GHPRVirtualFileSystem.Companion.getPath(path);
        }
        catch (Exception e) {
            LOG.debug("Cannot deserlialize file path", (Throwable)e);
            return null;
        }
        Path parsedPath = path2;
        Project project = ProjectManagerEx.getInstanceEx().findOpenProjectByHash(parsedPath.getProjectHash());
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Object object = GHPRDataContextRepository.Companion.getInstance(project2).findContext(parsedPath.getRepository());
        if (object == null || (object = ((GHPRDataContext)object).getFilesManager()) == null) {
            return null;
        }
        Object filesManager = object;
        return parsedPath.isDiff() ? (VirtualFile)filesManager.findDiffFile(parsedPath.getId()) : (VirtualFile)filesManager.findTimelineFile(parsedPath.getId());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        Object object;
        VirtualFile virtualFile = this.findFileByPath(path);
        if (!(virtualFile instanceof GHPRVirtualFile)) {
            virtualFile = null;
        }
        if ((object = (GHPRVirtualFile)virtualFile) == null || (object = object.getPresentablePath()) == null) {
            object = path;
        }
        return object;
    }

    public void refresh(boolean asynchronous) {
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(GHPRVirtualFileSystem.class);
        JACKSON = ExtensionsKt.jacksonObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem$Path;", "", "fileManagerId", "", "projectHash", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/SimpleGHPRIdentifier;", "isDiff", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/SimpleGHPRIdentifier;Z)V", "getFileManagerId", "()Ljava/lang/String;", "getId", "()Lorg/jetbrains/plugins/github/pullrequest/data/SimpleGHPRIdentifier;", "()Z", "getProjectHash", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.vcs.github"})
    private static final class Path {
        @NotNull
        private final String fileManagerId;
        @NotNull
        private final String projectHash;
        @NotNull
        private final GHRepositoryCoordinates repository;
        @NotNull
        private final SimpleGHPRIdentifier id;
        private final boolean isDiff;

        @NotNull
        public final String getFileManagerId() {
            return this.fileManagerId;
        }

        @NotNull
        public final String getProjectHash() {
            return this.projectHash;
        }

        @NotNull
        public final GHRepositoryCoordinates getRepository() {
            return this.repository;
        }

        @NotNull
        public final SimpleGHPRIdentifier getId() {
            return this.id;
        }

        public final boolean isDiff() {
            return this.isDiff;
        }

        public Path(@NotNull String fileManagerId, @NotNull String projectHash, @NotNull GHRepositoryCoordinates repository, @NotNull SimpleGHPRIdentifier id, boolean isDiff) {
            this.fileManagerId = fileManagerId;
            this.projectHash = projectHash;
            this.repository = repository;
            this.id = id;
            this.isDiff = isDiff;
        }

        @NotNull
        public final String component1() {
            return this.fileManagerId;
        }

        @NotNull
        public final String component2() {
            return this.projectHash;
        }

        @NotNull
        public final GHRepositoryCoordinates component3() {
            return this.repository;
        }

        @NotNull
        public final SimpleGHPRIdentifier component4() {
            return this.id;
        }

        public final boolean component5() {
            return this.isDiff;
        }

        @NotNull
        public final Path copy(@NotNull String fileManagerId, @NotNull String projectHash, @NotNull GHRepositoryCoordinates repository, @NotNull SimpleGHPRIdentifier id, boolean isDiff) {
            return new Path(fileManagerId, projectHash, repository, id, isDiff);
        }

        public static /* synthetic */ Path copy$default(Path path, String string, String string2, GHRepositoryCoordinates gHRepositoryCoordinates, SimpleGHPRIdentifier simpleGHPRIdentifier, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = path.fileManagerId;
            }
            if ((n & 2) != 0) {
                string2 = path.projectHash;
            }
            if ((n & 4) != 0) {
                gHRepositoryCoordinates = path.repository;
            }
            if ((n & 8) != 0) {
                simpleGHPRIdentifier = path.id;
            }
            if ((n & 0x10) != 0) {
                bl = path.isDiff;
            }
            return path.copy(string, string2, gHRepositoryCoordinates, simpleGHPRIdentifier, bl);
        }

        @NotNull
        public String toString() {
            return "Path(fileManagerId=" + this.fileManagerId + ", projectHash=" + this.projectHash + ", repository=" + this.repository + ", id=" + this.id + ", isDiff=" + this.isDiff + ")";
        }

        public int hashCode() {
            String string = this.fileManagerId;
            String string2 = this.projectHash;
            GHRepositoryCoordinates gHRepositoryCoordinates = this.repository;
            SimpleGHPRIdentifier simpleGHPRIdentifier = this.id;
            int n = ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (gHRepositoryCoordinates != null ? ((Object)gHRepositoryCoordinates).hashCode() : 0)) * 31 + (simpleGHPRIdentifier != null ? ((Object)simpleGHPRIdentifier).hashCode() : 0)) * 31;
            int n2 = this.isDiff ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Path)) break block3;
                    Path path = (Path)object;
                    if (!Intrinsics.areEqual((Object)this.fileManagerId, (Object)path.fileManagerId) || !Intrinsics.areEqual((Object)this.projectHash, (Object)path.projectHash) || !Intrinsics.areEqual((Object)this.repository, (Object)path.repository) || !Intrinsics.areEqual((Object)this.id, (Object)path.id) || this.isDiff != path.isDiff) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J0\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem$Companion;", "", "()V", "JACKSON", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PROTOCOL", "", "getInstance", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem;", "getPath", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFileSystem$Path;", "path", "fileManagerId", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "isDiff", "", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final String getPath(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier id, boolean isDiff) {
            return JACKSON.writeValueAsString((Object)new Path(fileManagerId, project.getLocationHash(), repository, new SimpleGHPRIdentifier(id), isDiff));
        }

        public static /* synthetic */ String getPath$default(Companion companion, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, GHPRIdentifier gHPRIdentifier, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return companion.getPath(string, project, gHRepositoryCoordinates, gHPRIdentifier, bl);
        }

        private final Path getPath(String path) {
            return (Path)JACKSON.readValue(path, Path.class);
        }

        @NotNull
        public final GHPRVirtualFileSystem getInstance() {
            boolean $i$f$service = false;
            VirtualFileSystem virtualFileSystem = ((VirtualFileManager)ApplicationManager.getApplication().getService(VirtualFileManager.class)).getFileSystem(GHPRVirtualFileSystem.PROTOCOL);
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
            }
            return (GHPRVirtualFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

