/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHOAuthServiceKt;
import org.jetbrains.plugins.github.authentication.ui.BaseLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsPanel;
import org.jetbrains.plugins.github.authentication.ui.GHOAuthLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.PasswordLoginDialog;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/AddGHAccountAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createDialog", "Lorg/jetbrains/plugins/github/authentication/ui/BaseLoginDialog;", "project", "Lcom/intellij/openapi/project/Project;", "accountsPanel", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsPanel;", "update", "intellij.vcs.github"})
public final class AddGHAccountAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getData(GHAccountsPanel.Companion.getKEY()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object = e.getData(GHAccountsPanel.Companion.getKEY());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        GHAccountsPanel accountsPanel = (GHAccountsPanel)((Object)object);
        BaseLoginDialog dialog2 = this.createDialog(e.getProject(), accountsPanel);
        dialog2.setServer("github.com", false);
        if (dialog2.showAndGet()) {
            accountsPanel.addAccount(dialog2.getServer(), dialog2.getLogin(), dialog2.getToken());
        }
    }

    private final BaseLoginDialog createDialog(Project project, GHAccountsPanel accountsPanel) {
        return GHOAuthServiceKt.isOAuthEnabled() ? (BaseLoginDialog)new GHOAuthLoginDialog(project, (Component)((Object)accountsPanel), (Function2<? super String, ? super GithubServerPath, Boolean>)((Function2)new Function2<String, GithubServerPath, Boolean>(accountsPanel){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                return ((GHAccountsPanel)((Object)this.receiver)).isAccountUnique(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GHAccountsPanel.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        })) : (BaseLoginDialog)new PasswordLoginDialog(project, (Component)((Object)accountsPanel), (Function2<? super String, ? super GithubServerPath, Boolean>)((Function2)new Function2<String, GithubServerPath, Boolean>(accountsPanel){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                return ((GHAccountsPanel)((Object)this.receiver)).isAccountUnique(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GHAccountsPanel.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        }));
    }
}

