/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubShareAction;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.request.Type;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "GithubExistingRemotesDialog", "GithubUntrackedFilesDialog", "intellij.vcs.github"})
public final class GithubShareAction
extends DumbAwareAction {
    private static final Logger LOG;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabledAndVisible(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed()) {
            return;
        }
        Companion.shareProjectOnGithub(project, file);
    }

    public GithubShareAction() {
        super(GithubBundle.messagePointer("share.action", new Object[0]), GithubBundle.messagePointer("share.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    static {
        Companion = new Companion(null);
        LOG = GithubUtil.LOG;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @JvmStatic
    public static final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
        Companion.shareProjectOnGithub(project, file);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubExistingRemotesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remotes", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    public static final class GithubExistingRemotesDialog
    extends DialogWrapper {
        private final List<String> remotes;

        @Nullable
        protected JComponent createCenterPanel() {
            Container $this$apply;
            boolean bl;
            JBLabel mainText = new JBLabel(this.remotes.size() == 1 ? GithubBundle.message("share.action.remote.is.on.github", new Object[0]) : GithubBundle.message("share.action.remotes.are.on.github", new Object[0]));
            JPanel jPanel = new JPanel();
            boolean bl2 = false;
            boolean bl3 = false;
            JPanel $this$apply2 = jPanel;
            boolean bl4 = false;
            $this$apply2.setLayout(new BoxLayout($this$apply2, 1));
            JPanel remotesPanel = jPanel;
            for (String remote : this.remotes) {
                JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
                boolean bl5 = false;
                bl = false;
                JPanel jPanel3 = jPanel2;
                JPanel jPanel4 = remotesPanel;
                boolean bl6 = false;
                $this$apply.add((Component)LinkLabel.create((String)remote, (Runnable)new Runnable(remote){
                    final /* synthetic */ String $remote$inlined;
                    {
                        this.$remote$inlined = string;
                    }

                    public final void run() {
                        BrowserUtil.browse((String)this.$remote$inlined);
                    }
                }));
                $this$apply.add((Component)new JBLabel(AllIcons.Ide.External_link_arrow));
                Unit unit = Unit.INSTANCE;
                jPanel4.add(jPanel2);
            }
            BorderLayoutPanel messagesPanel = JBUI.Panels.simplePanel((int)10, (int)4).addToTop((Component)mainText).addToCenter((Component)remotesPanel);
            Container container = new Container();
            boolean bl7 = false;
            bl = false;
            $this$apply = container;
            boolean bl8 = false;
            $this$apply.setLayout(new BorderLayout());
            $this$apply.add((Component)new JLabel(Messages.getQuestionIcon()), "North");
            Container iconContainer = container;
            container = JBUI.Panels.simplePanel((int)10, (int)4).addToCenter((Component)messagesPanel).addToLeft((Component)iconContainer);
            bl7 = false;
            bl = false;
            $this$apply = container;
            boolean bl9 = false;
            $this$apply.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            return (JComponent)container;
        }

        public GithubExistingRemotesDialog(@NotNull Project project, @NotNull List<String> remotes) {
            super(project);
            this.remotes = remotes;
            this.setTitle(GithubBundle.message("share.error.project.is.on.github", new Object[0]));
            this.setOKButtonText(GithubBundle.message("share.anyway.button", new Object[0]));
            this.init();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\nH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0014R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubUntrackedFilesDialog;", "Lcom/intellij/openapi/vcs/changes/ui/SelectFilesDialog;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "untrackedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "commitMessage", "", "getCommitMessage", "()Ljava/lang/String;", "myCommitMessagePanel", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "createCenterPanel", "Ljavax/swing/JComponent;", "createNorthPanel", "getData", "", "dataId", "getDimensionServiceKey", "intellij.vcs.github"})
    public static final class GithubUntrackedFilesDialog
    extends SelectFilesDialog
    implements DataProvider {
        private CommitMessage myCommitMessagePanel;
        private final Project myProject;

        @NotNull
        public final String getCommitMessage() {
            CommitMessage commitMessage = this.myCommitMessagePanel;
            if (commitMessage == null) {
                Intrinsics.throwNpe();
            }
            return commitMessage.getComment();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JComponent tree2 = super.createCenterPanel();
            CommitMessage commitMessage = new CommitMessage(this.myProject);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)commitMessage));
            commitMessage.setCommitMessage("Initial commit");
            this.myCommitMessagePanel = commitMessage;
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree2);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return (JComponent)splitter;
        }

        @Nullable
        public Object getData(@NonNls @NotNull String dataId) {
            return VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId) ? this.myCommitMessagePanel : null;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "Github.UntrackedFilesDialog";
        }

        public GithubUntrackedFilesDialog(@NotNull Project myProject, @NotNull List<? extends VirtualFile> untrackedFiles) {
            super(myProject, untrackedFiles, null, null, true, false);
            this.myProject = myProject;
            this.setTitle(GithubBundle.message("untracked.files.dialog.title", new Object[0]));
            this.setOKButtonText(CommonBundle.getAddButtonText());
            this.setCancelButtonText(CommonBundle.getCancelButtonText());
            this.init();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "shareProjectOnGithub", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github"})
    public static final class Companion {
        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        public final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
            block15: {
                block14: {
                    FileDocumentManager.getInstance().saveAllDocuments();
                    gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
                    $i$f$service = false;
                    if (!GithubAccountsMigrationHelper.migrate$default((GithubAccountsMigrationHelper)ApplicationManager.getApplication().getService(GithubAccountsMigrationHelper.class), project, null, 2, null)) {
                        return;
                    }
                    $i$f$service = false;
                    authManager = (GithubAuthenticationManager)ApplicationManager.getApplication().getService(GithubAuthenticationManager.class);
                    if (!GithubAuthenticationManager.ensureHasAccounts$default(authManager, project, null, 2, null)) {
                        return;
                    }
                    accounts = authManager.getAccounts();
                    $i$f$service = false;
                    progressManager = (ProgressManager)ApplicationManager.getApplication().getService(ProgressManager.class);
                    $i$f$service = false;
                    requestExecutorManager = (GithubApiRequestExecutorManager)ApplicationManager.getApplication().getService(GithubApiRequestExecutorManager.class);
                    $i$f$service = false;
                    accountInformationProvider = (GithubAccountInformationProvider)ApplicationManager.getApplication().getService(GithubAccountInformationProvider.class);
                    $i$f$service = false;
                    gitHelper = (GithubGitHelper)ApplicationManager.getApplication().getService(GithubGitHelper.class);
                    $i$f$service = false;
                    git = (Git)ApplicationManager.getApplication().getService(Git.class);
                    v0 /* !! */  = gitRepository;
                    if (v0 /* !! */  == null) ** GOTO lbl-1000
                    var12_19 = v0 /* !! */ ;
                    $this$service$iv /* !! */  = project;
                    $i$f$service = false;
                    $this$service$iv /* !! */  = $this$service$iv /* !! */ .getService(GHProjectRepositoriesManager.class);
                    $i$f$service = false;
                    var15_28 = false;
                    p1 = var12_19;
                    $i$a$-unknown-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$1 = false;
                    v0 /* !! */  = ((GHProjectRepositoriesManager)$this$service$iv /* !! */ ).findKnownRepositories(p1);
                    if (v0 /* !! */  != null) {
                        $this$map$iv /* !! */  = (Iterable)v0 /* !! */ ;
                        $i$f$map = false;
                        $i$f$service /* !! */  = $this$map$iv /* !! */ ;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv /* !! */ , (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var19_43 = (GHGitRepositoryMapping)item$iv$iv;
                            var23_46 = destination$iv$iv;
                            $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$2 = false;
                            var24_47 = it.getGitRemote().getUrl();
                            var23_46.add(var24_47);
                        }
                        v1 = (List)destination$iv$iv;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = null;
                    }
                    $this$map$iv /* !! */  = v1;
                    $i$f$map = false;
                    v2 = $this$map$iv /* !! */ ;
                    if (v2 == null) {
                        v2 = CollectionsKt.emptyList();
                    }
                    possibleRemotes = v2;
                    $this$map$iv /* !! */  = possibleRemotes;
                    $i$f$map = false;
                    if ($this$map$iv /* !! */ .isEmpty() == false) {
                        existingRemotesDialog = new GithubExistingRemotesDialog(project, possibleRemotes);
                        DialogManager.show((DialogWrapper)existingRemotesDialog);
                        if (!existingRemotesDialog.isOK()) {
                            return;
                        }
                    }
                    accountInformationLoader = new Function2<GithubAccount, Component, Pair<? extends Boolean, ? extends Set<? extends String>>>(requestExecutorManager, progressManager, project){
                        private final Map<GithubAccount, Pair<Boolean, Set<String>>> loadedInfo;
                        final /* synthetic */ GithubApiRequestExecutorManager $requestExecutorManager;
                        final /* synthetic */ ProgressManager $progressManager;
                        final /* synthetic */ Project $project;

                        @NotNull
                        public Pair<Boolean, Set<String>> invoke(@NotNull GithubAccount account, @NotNull Component parentComponent) throws IOException {
                            Pair pair;
                            Map<GithubAccount, Pair<Boolean, Set<String>>> $this$getOrPut$iv = this.loadedInfo;
                            boolean $i$f$getOrPut = false;
                            Pair value$iv = $this$getOrPut$iv.get(account);
                            if (value$iv == null) {
                                boolean bl = false;
                                GithubApiRequestExecutor.WithTokenAuth withTokenAuth = this.$requestExecutorManager.getExecutor(account, parentComponent);
                                if (withTokenAuth == null) {
                                    throw (Throwable)new ProcessCanceledException();
                                }
                                GithubApiRequestExecutor.WithTokenAuth requestExecutor = withTokenAuth;
                                Pair answer$iv = (Pair)this.$progressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Pair<? extends Boolean, ? extends Set<? extends String>>, IOException>(requestExecutor, this, account, parentComponent){
                                    final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
                                    final /* synthetic */ shareProjectOnGithub.accountInformationLoader.1 this$0;
                                    final /* synthetic */ GithubAccount $account$inlined;
                                    final /* synthetic */ Component $parentComponent$inlined;
                                    {
                                        this.$requestExecutor = withTokenAuth;
                                        this.this$0 = var2_2;
                                        this.$account$inlined = githubAccount;
                                        this.$parentComponent$inlined = component;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Pair<Boolean, Set<String>> compute() {
                                        Set set;
                                        void size$iv;
                                        GithubAuthenticatedUser user = this.$requestExecutor.execute(this.this$0.$progressManager.getProgressIndicator(), GithubApiRequests.CurrentUser.get(this.$account$inlined.getServer()));
                                        Collection $this$mapSmartSet$iv = GithubApiPagesLoader.loadAll(this.$requestExecutor, this.this$0.$progressManager.getProgressIndicator(), GithubApiRequests.CurrentUser.Repos.pages$default(this.$account$inlined.getServer(), Type.OWNER, null, null, null, 28, null));
                                        boolean $i$f$mapSmartSet = false;
                                        int n = $this$mapSmartSet$iv.size();
                                        switch (size$iv) {
                                            case 1: {
                                                GithubRepo it = (GithubRepo)CollectionsKt.first((Iterable)$this$mapSmartSet$iv);
                                                boolean bl = false;
                                                set = Collections.singleton(it.getName());
                                                break;
                                            }
                                            case 0: {
                                                set = SetsKt.emptySet();
                                                break;
                                            }
                                            default: {
                                                void $this$mapTo$iv$iv;
                                                Iterable iterable = $this$mapSmartSet$iv;
                                                Collection destination$iv$iv = (Collection)new com.intellij.util.containers.HashSet((int)size$iv);
                                                boolean $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    void it;
                                                    GithubRepo githubRepo = (GithubRepo)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl = false;
                                                    String string = it.getName();
                                                    collection.add(string);
                                                }
                                                set = (Set)destination$iv$iv;
                                            }
                                        }
                                        Set names = set;
                                        return TuplesKt.to((Object)user.canCreatePrivateRepo(), (Object)names);
                                    }
                                }, GithubBundle.message("share.process.loading.account.info", account), true, this.$project);
                                $this$getOrPut$iv.put(account, (Pair<Boolean, Set<String>>)answer$iv);
                                pair = answer$iv;
                            } else {
                                pair = value$iv;
                            }
                            return pair;
                        }
                        {
                            this.$requestExecutorManager = $captured_local_variable$0;
                            this.$progressManager = $captured_local_variable$1;
                            this.$project = $captured_local_variable$2;
                            boolean bl = false;
                            this.loadedInfo = new LinkedHashMap<K, V>();
                        }
                    };
                    v3 = project;
                    v4 = accounts;
                    v5 = authManager.getDefaultAccount(project);
                    v6 /* !! */  = gitRepository;
                    if (v6 /* !! */  == null || (v6 /* !! */  = v6 /* !! */ .getRemotes()) == null) break block14;
                    $this$mapTo$iv$iv = (Iterable)v6 /* !! */ ;
                    var27_48 = v5;
                    var26_49 = v4;
                    var25_50 = v3;
                    $i$f$map = false;
                    $i$f$mapTo = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var21_51 = (GitRemote)item$iv$iv;
                        var28_53 = destination$iv$iv;
                        $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$shareDialog$1 = false;
                        var29_54 = it.getName();
                        var28_53.add(var29_54);
                    }
                    var28_53 = (List)destination$iv$iv;
                    v3 = var25_50;
                    v4 = var26_49;
                    v5 = var27_48;
                    v6 /* !! */  = CollectionsKt.toSet((Iterable)var28_53);
                    if (v6 /* !! */  != null) break block15;
                }
                v6 /* !! */  = SetsKt.emptySet();
            }
            var30_55 = (Function2)accountInformationLoader;
            var31_56 /* !! */  = v6 /* !! */ ;
            var32_57 = v5;
            var33_58 = v4;
            var34_59 = v3;
            shareDialog = new GithubShareDialog(var34_59, var33_58, var32_57, (Set<String>)var31_56 /* !! */ , (Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>>)var30_55);
            DialogManager.show((DialogWrapper)shareDialog);
            if (!shareDialog.isOK()) {
                return;
            }
            name = shareDialog.getRepositoryName();
            isPrivate = shareDialog.isPrivate();
            remoteName = shareDialog.getRemoteName();
            description = shareDialog.getDescription();
            account = shareDialog.getAccount();
            v7 = requestExecutorManager.getExecutor(account, project);
            if (v7 == null) {
                return;
            }
            requestExecutor = v7;
            new Task.Backgroundable(requestExecutor, account, name, description, isPrivate, gitRepository, project, accountInformationProvider, gitHelper, git, remoteName, project, GithubBundle.message("share.process", new Object[0])){
                private String url;
                final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
                final /* synthetic */ GithubAccount $account;
                final /* synthetic */ String $name;
                final /* synthetic */ String $description;
                final /* synthetic */ boolean $isPrivate;
                final /* synthetic */ GitRepository $gitRepository;
                final /* synthetic */ Project $project;
                final /* synthetic */ GithubAccountInformationProvider $accountInformationProvider;
                final /* synthetic */ GithubGitHelper $gitHelper;
                final /* synthetic */ Git $git;
                final /* synthetic */ String $remoteName;

                public void run(@NotNull ProgressIndicator indicator) {
                    GitRepositoryManager repositoryManager;
                    GitRepository repository;
                    GithubShareAction.access$getLOG$cp().info("Creating GitHub repository");
                    indicator.setText(GithubBundle.message("share.process.creating.repository", new Object[0]));
                    this.url = ((GithubRepo)this.$requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.Repos.create$default(this.$account.getServer(), this.$name, this.$description, this.$isPrivate, null, 16, null))).getHtmlUrl();
                    GithubShareAction.access$getLOG$cp().info("Successfully created GitHub repository");
                    GitRepository gitRepository = this.$gitRepository;
                    if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
                        gitRepository = this.$project.getBaseDir();
                    }
                    GitRepository root = gitRepository;
                    GithubShareAction.access$getLOG$cp().info("Binding local project with GitHub");
                    if (this.$gitRepository == null) {
                        GithubShareAction.access$getLOG$cp().info("No git detected, creating empty git repo");
                        indicator.setText(GithubBundle.message("share.process.creating.git.repository", new Object[0]));
                        if (!this.createEmptyGitRepository(this.$project, (VirtualFile)root)) {
                            return;
                        }
                    }
                    if ((repository = (GitRepository)(repositoryManager = GitUtil.getRepositoryManager((Project)this.$project)).getRepositoryForRoot((VirtualFile)root)) == null) {
                        GithubNotifications.showError(this.$project, GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), GithubBundle.message("cannot.find.git.repo", new Object[0]));
                        return;
                    }
                    indicator.setText(GithubBundle.message("share.process.retrieving.username", new Object[0]));
                    String username = this.$accountInformationProvider.getInformation(this.$requestExecutor, indicator, this.$account).getLogin();
                    String remoteUrl = this.$gitHelper.getRemoteUrl(this.$account.getServer(), username, this.$name);
                    GithubShareAction.access$getLOG$cp().info("Adding GitHub as a remote host");
                    indicator.setText(GithubBundle.message("share.process.adding.gh.as.remote.host", new Object[0]));
                    this.$git.addRemote(repository, this.$remoteName, remoteUrl).throwOnError(new int[0]);
                    repository.update();
                    String string = this.url;
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    if (!this.performFirstCommitIfRequired(this.$project, (VirtualFile)root, repository, indicator, this.$name, string)) {
                        return;
                    }
                    GithubShareAction.access$getLOG$cp().info("Pushing to github master");
                    indicator.setText(GithubBundle.message("share.process.pushing.to.github.master", new Object[0]));
                    String string2 = this.url;
                    if (string2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    if (!this.pushCurrentBranch(this.$project, repository, this.$remoteName, remoteUrl, this.$name, string2)) {
                        return;
                    }
                    String string3 = GithubBundle.message("share.process.successfully.shared", new Object[0]);
                    String string4 = this.url;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    GithubNotifications.showInfoURL(this.$project, string3, this.$name, string4);
                }

                private final boolean createEmptyGitRepository(Project project, VirtualFile root) {
                    GitCommandResult result = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
                    if (!result.success()) {
                        VcsNotifier.getInstance((Project)project).notifyError(GitBundle.getString((String)"initializing.title"), result.getErrorOutputAsHtmlString());
                        GithubShareAction.access$getLOG$cp().info("Failed to create empty git repo: " + result.getErrorOutputAsJoinedString());
                        return false;
                    }
                    GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
                    GitUtil.generateGitignoreFileIfNeeded((Project)project, (VirtualFile)root);
                    return true;
                }

                /*
                 * WARNING - void declaration
                 */
                private final boolean performFirstCommitIfRequired(Project project, VirtualFile root, GitRepository repository, ProgressIndicator indicator, String name, String url) {
                    if (!repository.isFresh()) {
                        return true;
                    }
                    GithubShareAction.access$getLOG$cp().info("Trying to commit");
                    try {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        GithubShareAction.access$getLOG$cp().info("Adding files for commit");
                        indicator.setText(GithubBundle.message("share.process.adding.files", new Object[0]));
                        List trackedFiles = ChangeListManager.getInstance((Project)project).getAffectedFiles();
                        Iterable iterable = repository.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
                        Project project2 = project;
                        shareProjectOnGithub.1 var27_11 = this;
                        boolean $i$f$mapNotNull = false;
                        void var11_14 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            VirtualFile virtualFile;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            FilePath p1 = (FilePath)element$iv$iv;
                            boolean bl2 = false;
                            if (p1.getVirtualFile() == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            VirtualFile it$iv$iv = virtualFile;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list2 = (List)destination$iv$iv;
                        Collection<VirtualFile> untrackedFiles = var27_11.filterOutIgnored(project2, list2);
                        trackedFiles.removeAll(untrackedFiles);
                        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
                        allFiles.addAll(trackedFiles);
                        allFiles.addAll(untrackedFiles);
                        GithubUntrackedFilesDialog dialog2 = (GithubUntrackedFilesDialog)((Object)ActionsKt.invokeAndWaitIfNeeded((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<GithubUntrackedFilesDialog>(project, allFiles, trackedFiles){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ArrayList $allFiles;
                            final /* synthetic */ List $trackedFiles;

                            @NotNull
                            public final GithubUntrackedFilesDialog invoke() {
                                GithubUntrackedFilesDialog githubUntrackedFilesDialog = new GithubUntrackedFilesDialog(this.$project, this.$allFiles);
                                boolean bl = false;
                                boolean bl2 = false;
                                GithubUntrackedFilesDialog $this$apply = githubUntrackedFilesDialog;
                                boolean bl3 = false;
                                if (!this.$trackedFiles.isEmpty()) {
                                    $this$apply.setSelectedFiles(this.$trackedFiles);
                                }
                                DialogManager.show((DialogWrapper)((DialogWrapper)$this$apply));
                                return githubUntrackedFilesDialog;
                            }
                            {
                                this.$project = project;
                                this.$allFiles = arrayList;
                                this.$trackedFiles = list2;
                                super(0);
                            }
                        })));
                        Collection files2commit = dialog2.getSelectedFiles();
                        if (!dialog2.isOK() || files2commit.isEmpty()) {
                            GithubNotifications.showInfoURL(project, GithubBundle.message("share.process.empty.project.created", new Object[0]), name, url);
                            return false;
                        }
                        Collection files2add = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
                        Collection files2rm = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
                        HashSet<E> modified = new HashSet<E>(trackedFiles);
                        modified.addAll(files2commit);
                        GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
                        GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
                        GithubShareAction.access$getLOG$cp().info("Performing commit");
                        indicator.setText(GithubBundle.message("share.process.performing.commit", new Object[0]));
                        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
                        handler.setStdoutSuppressed(false);
                        handler.addParameters(new String[]{"-m", dialog2.getCommitMessage()});
                        handler.endOptions();
                        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
                        VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
                    }
                    catch (VcsException e) {
                        GithubShareAction.access$getLOG$cp().warn((Throwable)e);
                        GithubNotifications.showErrorURL(project, GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.init.commit.failed", new Object[0]) + GithubUtil.getErrorTextFromException(e), url);
                        return false;
                    }
                    GithubShareAction.access$getLOG$cp().info("Successfully created initial commit");
                    return true;
                }

                private final Collection<VirtualFile> filterOutIgnored(Project project, Collection<? extends VirtualFile> files) {
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                    return ContainerUtil.filter(files, (Condition)((Condition)new Condition<VirtualFile>(changeListManager, vcsManager){
                        final /* synthetic */ ChangeListManager $changeListManager;
                        final /* synthetic */ ProjectLevelVcsManager $vcsManager;

                        public final boolean value(VirtualFile file) {
                            return !this.$changeListManager.isIgnoredFile(file) && !this.$vcsManager.isIgnored(file);
                        }
                        {
                            this.$changeListManager = changeListManager;
                            this.$vcsManager = projectLevelVcsManager;
                        }
                    }));
                }

                private final boolean pushCurrentBranch(Project project, GitRepository repository, String remoteName, String remoteUrl, String name, String url) {
                    GitLocalBranch currentBranch = repository.getCurrentBranch();
                    if (currentBranch == null) {
                        GithubNotifications.showErrorURL(project, GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.no.current.branch", new Object[0]), url);
                        return false;
                    }
                    GitCommandResult result = this.$git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
                    if (!result.success()) {
                        GithubNotifications.showErrorURL(project, GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.failed", result.getErrorOutputAsHtmlString()), url);
                        return false;
                    }
                    return true;
                }

                public void onThrowable(@NotNull Throwable error) {
                    GithubNotifications.showError(this.$project, GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), error);
                }
                {
                    this.$requestExecutor = $captured_local_variable$0;
                    this.$account = $captured_local_variable$1;
                    this.$name = $captured_local_variable$2;
                    this.$description = $captured_local_variable$3;
                    this.$isPrivate = $captured_local_variable$4;
                    this.$gitRepository = $captured_local_variable$5;
                    this.$project = $captured_local_variable$6;
                    this.$accountInformationProvider = $captured_local_variable$7;
                    this.$gitHelper = $captured_local_variable$8;
                    this.$git = $captured_local_variable$9;
                    this.$remoteName = $captured_local_variable$10;
                    super($super_call_param$11, $super_call_param$12);
                }
            }.queue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

