/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.AbstractAuthenticatingGithubUrlGroupingAction;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRebaseAction
extends AbstractAuthenticatingGithubUrlGroupingAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String UPSTREAM_REMOTE = "upstream";

    public GithubRebaseAction() {
        super(GithubBundle.messagePointer("rebase.action", new Object[0]), GithubBundle.messagePointer("rebase.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GHGitRepositoryMapping repository, @NotNull GithubAccount account) {
        FileDocumentManager.getInstance().saveAllDocuments();
        GithubApiRequestExecutor.WithTokenAuth executor = GithubApiRequestExecutorManager.getInstance().getExecutor(account, project);
        if (executor == null) {
            return;
        }
        new RebaseTask(project, executor, Git.getInstance(), account.getServer(), repository.getGitRemote().getRepository(), repository.getRepository().getRepositoryPath()).queue();
    }

    private static class RebaseTask
    extends Task.Backgroundable {
        @NotNull
        private final GithubApiRequestExecutor myRequestExecutor;
        @NotNull
        private final Git myGit;
        @NotNull
        private final GithubServerPath myServer;
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final GHRepositoryPath myRepoPath;

        RebaseTask(@NotNull Project project, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull Git git, @NotNull GithubServerPath server, @NotNull GitRepository repository, @NotNull GHRepositoryPath repoPath) {
            super(project, GithubBundle.message("rebase.process", new Object[0]));
            this.myRequestExecutor = requestExecutor;
            this.myGit = git;
            this.myServer = server;
            this.myRepository = repository;
            this.myRepoPath = repoPath;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            GHRepositoryPath userAndRepo;
            this.myRepository.update();
            String upstreamRemoteUrl = this.findUpstreamRemoteUrl();
            if (upstreamRemoteUrl == null) {
                indicator.setText(GithubBundle.message("rebase.process.configuring.upstream.remote", new Object[0]));
                LOG.info("Configuring upstream remote");
                upstreamRemoteUrl = this.configureUpstreamRemote(indicator);
                if (upstreamRemoteUrl == null) {
                    return;
                }
            }
            if ((userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(upstreamRemoteUrl)) == null) {
                GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("cannot.validate.upstream", upstreamRemoteUrl));
                return;
            }
            if (this.isUpstreamWithSameUsername(indicator, userAndRepo)) {
                GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.upstream.is.own.repo", upstreamRemoteUrl));
                return;
            }
            String name = this.getDefaultBranchName(indicator, userAndRepo);
            if (name == null) {
                return;
            }
            String onto = "upstream/" + name;
            LOG.info("Fetching upstream");
            indicator.setText(GithubBundle.message("rebase.process.fetching.upstream", new Object[0]));
            if (!this.fetchParent()) {
                return;
            }
            LOG.info("Rebasing current branch");
            indicator.setText(GithubBundle.message("rebase.process.rebasing.branch.onto", onto));
            this.rebaseCurrentBranch(indicator, onto);
        }

        @Nullable
        private String findUpstreamRemoteUrl() {
            return this.myRepository.getRemotes().stream().filter(remote -> remote.getName().equals(GithubRebaseAction.UPSTREAM_REMOTE) && remote.getFirstUrl() != null && this.myServer.matches(remote.getFirstUrl())).findFirst().map(GitRemote::getFirstUrl).orElse(null);
        }

        private boolean isUpstreamWithSameUsername(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath userAndRepo) {
            try {
                String username = this.myRequestExecutor.execute(indicator, GithubApiRequests.CurrentUser.get(this.myServer)).getLogin();
                return userAndRepo.getOwner().equals(username);
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("cannot.get.user.info", new Object[0]));
                return true;
            }
        }

        @Nullable
        private String getDefaultBranchName(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath userAndRepo) {
            try {
                GithubRepo repo = this.myRequestExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, userAndRepo.getOwner(), userAndRepo.getRepository()));
                if (repo == null) {
                    GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("cannot.retrieve.upstream.info", userAndRepo));
                    return null;
                }
                return repo.getDefaultBranch();
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("cannot.retrieve.upstream.info", userAndRepo), e.getMessage());
                return null;
            }
        }

        @Nullable
        private String configureUpstreamRemote(@NotNull ProgressIndicator indicator) {
            GithubRepoDetailed repositoryInfo = this.loadRepositoryInfo(indicator, this.myRepoPath);
            if (repositoryInfo == null) {
                return null;
            }
            if (!repositoryInfo.isFork() || repositoryInfo.getParent() == null) {
                GithubNotifications.showWarningURL(this.myProject, GithubBundle.message("rebase.error", new Object[0]), "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
                return null;
            }
            String parentRepoUrl = GithubGitHelper.getInstance().getRemoteUrl(this.myServer, repositoryInfo.getParent().getFullPath());
            LOG.info("Adding GitHub parent as a remote host");
            indicator.setText(GithubBundle.message("rebase.process.adding.github.parent.as.remote.host", new Object[0]));
            try {
                this.myGit.addRemote(this.myRepository, GithubRebaseAction.UPSTREAM_REMOTE, parentRepoUrl).throwOnError(new int[0]);
            }
            catch (VcsException e) {
                GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("cannot.configure.remote", GithubRebaseAction.UPSTREAM_REMOTE, e.getMessage()));
                return null;
            }
            this.myRepository.update();
            return parentRepoUrl;
        }

        @Nullable
        private GithubRepoDetailed loadRepositoryInfo(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath fullPath) {
            try {
                GithubRepoDetailed repo = this.myRequestExecutor.execute(indicator, GithubApiRequests.Repos.get(this.myServer, fullPath.getOwner(), fullPath.getRepository()));
                if (repo == null) {
                    GithubNotifications.showError(this.myProject, GithubBundle.message("rebase.error.repo.not.found", fullPath.toString()), "");
                }
                return repo;
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, GithubBundle.message("cannot.load.repo.info", new Object[0]), e);
                return null;
            }
        }

        private boolean fetchParent() {
            GitRemote remote = GitUtil.findRemoteByName((GitRepository)this.myRepository, (String)GithubRebaseAction.UPSTREAM_REMOTE);
            if (remote == null) {
                LOG.warn("Couldn't find remote  remoteName  in " + this.myRepository);
                return false;
            }
            return GitFetchSupport.fetchSupport((Project)this.myProject).fetch(this.myRepository, remote).showNotificationIfFailed();
        }

        private void rebaseCurrentBranch(@NotNull ProgressIndicator indicator, String onto) {
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message((String)"rebase.git.operation.name", (Object[])new Object[0]));){
                List<VirtualFile> rootsToSave = Collections.singletonList(this.myRepository.getRoot());
                GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance((Project)this.myProject).getSaveChangesPolicy();
                GitPreservingProcess process = new GitPreservingProcess(this.myProject, this.myGit, rootsToSave, GithubBundle.message("rebase.process.operation.title", new Object[0]), onto, saveMethod, indicator, () -> this.doRebaseCurrentBranch(indicator, onto));
                process.execute();
            }
        }

        private void doRebaseCurrentBranch(@NotNull ProgressIndicator indicator, String onto) {
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)this.myProject);
            GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, indicator);
            VirtualFile root = this.myRepository.getRoot();
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{onto});
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
            handler.addLineListener((GitLineHandlerListener)localChangesDetector);
            handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
            String oldText = indicator.getText();
            indicator.setText(GithubBundle.message("rebase.process.rebasing.onto", onto));
            GitCommandResult rebaseResult = this.myGit.runCommand(handler);
            indicator.setText(oldText);
            repositoryManager.updateRepository(root);
            if (rebaseResult.success()) {
                root.refresh(false, true);
                GithubNotifications.showInfo(this.myProject, GithubBundle.message("rebase.process.success", new Object[0]), "");
            } else {
                GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseResult, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
                if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    GithubNotifications.showInfo(this.myProject, GithubBundle.message("rebase.process.success", new Object[0]), "");
                }
            }
        }
    }
}

