/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NotNull;

public class AddDomElementQuickFix<T extends DomElement>
implements LocalQuickFix {
    protected final T myElement;
    protected final String myName;

    public AddDomElementQuickFix(@NotNull T element) {
        this.myElement = element.createStableCopy();
        this.myName = this.computeName();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    private String computeName() {
        String name = this.myElement.getXmlElementName();
        return XmlDomBundle.message(this.isTag() ? "add.element.fix.name" : "add.attribute.fix.name", name);
    }

    private boolean isTag() {
        return this.myElement.getXmlElement() instanceof XmlTag;
    }

    @NotNull
    public String getFamilyName() {
        return XmlDomBundle.message("add.element.fix.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlElement element = this.myElement.ensureXmlElementExists();
        XmlElement navigationElement = this.isTag() ? element : ((XmlAttribute)element).getValueElement();
        PsiNavigateUtil.navigate((PsiElement)navigationElement);
    }
}

