/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GenericValueUtil {
    public static NullableFunction<GenericValue, String> STRING_VALUE = genericValue -> genericValue.getStringValue();
    public static NullableFunction<GenericValue, Object> OBJECT_VALUE = genericValue -> genericValue.getValue();

    private GenericValueUtil() {
    }

    public static boolean containsString(Collection<? extends GenericValue<?>> collection, String value) {
        for (GenericValue<?> o : collection) {
            if (!Objects.equals(value, o.getStringValue())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsValue(Collection<? extends GenericValue<? extends T>> collection, T value) {
        for (GenericValue<T> o : collection) {
            if (!Comparing.equal(value, o.getValue())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> Collection<T> getValueCollection(Collection<? extends GenericValue<? extends T>> collection, Collection<T> result) {
        for (GenericValue<T> o : collection) {
            ContainerUtil.addIfNotNull(result, o.getValue());
        }
        return result;
    }

    @NotNull
    public static Collection<String> getStringCollection(Collection<? extends GenericValue> collection, Collection<String> result) {
        for (GenericValue genericValue : collection) {
            ContainerUtil.addIfNotNull(result, (Object)genericValue.getStringValue());
        }
        return result;
    }

    @NotNull
    public static Collection<String> getClassStringCollection(Collection<? extends GenericValue> collection, Collection<String> result) {
        for (GenericValue genericValue : collection) {
            String value = genericValue.getStringValue();
            if (value == null) continue;
            result.add(value.replace('$', '.'));
        }
        return result;
    }
}

