/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.util.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.ReceiverTypeSearcherInfo;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.usagesSearch.JavaConstructorCallLazyDescriptorHandle;
import org.jetbrains.kotlin.idea.search.usagesSearch.KotlinConstructorCallLazyDescriptorHandle;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u001e\u001a\u00020\fH\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016Jf\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00172\u0006\u0010&\u001a\u00020-2\u0006\u0010.\u001a\u00020\n26\u0010/\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\n00H\u0016J,\u00105\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010&\u001a\u00020-2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n06H\u0016J\u001e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020;0\u0017H\u0016J\u0010\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00172\u0006\u00109\u001a\u00020:H\u0016J\u001a\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\nH\u0016J\u0010\u0010F\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020GH\u0016J\u0018\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0006\u001a\u00020,H\u0016J\u0010\u0010K\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010L\u001a\u00020\n2\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0006\u001a\u00020,H\u0016J\u0018\u0010M\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010N\u001a\u00020\nH\u0016J\u0010\u0010O\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010P\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010Q\u001a\u00020\n2\u0006\u0010R\u001a\u00020SH\u0016J\u0018\u0010T\u001a\u00020\n2\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0006\u001a\u00020,H\u0016J\u0010\u0010U\u001a\u00020\n2\u0006\u00109\u001a\u00020VH\u0016\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/idea/search/KotlinSearchUsagesSupportImpl;", "Lorg/jetbrains/kotlin/idea/search/KotlinSearchUsagesSupport;", "()V", "actualsForExpected", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "module", "Lcom/intellij/openapi/module/Module;", "canBeResolvedWithFrontEnd", "", "element", "Lcom/intellij/psi/PsiElement;", "createConstructorHandle", "Lorg/jetbrains/kotlin/idea/search/KotlinSearchUsagesSupport$ConstructorCallHandle;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "ktDeclaration", "dataClassComponentMethodName", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "expectedDeclarationIfAny", "filterDataClassComponentsIfDisabled", "", "T", "Lcom/intellij/psi/PsiNamedElement;", "elements", "kotlinOptions", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "findDeepestSuperMethodsNoWrapping", "method", "findSuperMethodsNoWrapping", "findTypeAliasByShortName", "", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "shortName", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "forEachKotlinOverride", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "members", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lcom/intellij/psi/search/SearchScope;", "searchDeeply", "processor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "superMember", "overridingMember", "forEachOverridingMethod", "Lkotlin/Function1;", "forceResolveReferences", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/KtElement;", "formatClass", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "formatJavaOrLightMethod", "getDefaultImports", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "getReceiverTypeSearcherInfo", "Lorg/jetbrains/kotlin/idea/search/ReceiverTypeSearcherInfo;", "psiElement", "isDestructionDeclarationSearch", "hasType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isCallableOverrideUsage", "reference", "Lcom/intellij/psi/PsiReference;", "isExpectDeclaration", "isExtensionOfDeclarationClassUsage", "isInProjectSource", "includeScriptsOutsideSourceRoots", "isInheritable", "isOverridable", "isSamInterface", "psiClass", "Lcom/intellij/psi/PsiClass;", "isUsageInContainingDeclaration", "scriptDefinitionExists", "Lcom/intellij/psi/PsiFile;", "kotlin.idea"})
public final class KotlinSearchUsagesSupportImpl
implements KotlinSearchUsagesSupport {
    @NotNull
    public Set<KtDeclaration> actualsForExpected(@NotNull KtDeclaration declaration2, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return ExpectActualUtilKt.actualsForExpected((KtDeclaration)declaration2, (Module)module);
    }

    @Nullable
    public String dataClassComponentMethodName(@NotNull KtParameter element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        FunctionDescriptor functionDescriptor2 = SearchHelpersKt.dataClassComponentFunction((KtParameter)element3);
        return functionDescriptor2 != null && (functionDescriptor2 = functionDescriptor2.getName()) != null ? functionDescriptor2.asString() : null;
    }

    public boolean hasType(@NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return UtilsKt.hasType(element3);
    }

    public boolean isSamInterface(@NotNull PsiClass psiClass2) {
        Intrinsics.checkNotNullParameter((Object)psiClass2, (String)"psiClass");
        return UtilsKt.isSamInterface(psiClass2);
    }

    @NotNull
    public <T extends PsiNamedElement> List<T> filterDataClassComponentsIfDisabled(@NotNull List<? extends T> elements2, @NotNull KotlinReferencesSearchOptions kotlinOptions) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)kotlinOptions, (String)"kotlinOptions");
        return UtilsKt.filterDataClassComponentsIfDisabled(elements2, kotlinOptions);
    }

    public boolean isCallableOverrideUsage(@NotNull PsiReference reference2, @NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return UtilsKt.isCallableOverrideUsage(reference2, declaration2);
    }

    public boolean isUsageInContainingDeclaration(@NotNull PsiReference reference2, @NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return UtilsKt.isUsageInContainingDeclaration(reference2, declaration2);
    }

    public boolean isExtensionOfDeclarationClassUsage(@NotNull PsiReference reference2, @NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return UtilsKt.isExtensionOfDeclarationClassUsage(reference2, declaration2);
    }

    @Nullable
    public ReceiverTypeSearcherInfo getReceiverTypeSearcherInfo(@NotNull PsiElement psiElement2, boolean isDestructionDeclarationSearch) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        return UtilsKt.getReceiverTypeSearcherInfo(psiElement2, isDestructionDeclarationSearch);
    }

    public void forceResolveReferences(@NotNull KtFile file, @NotNull List<? extends KtElement> elements2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        UtilsKt.forceResolveReferences(file, elements2);
    }

    public boolean scriptDefinitionExists(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.scriptDefinitionExists(file);
    }

    @NotNull
    public List<ImportPath> getDefaultImports(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.getDefaultImports(file);
    }

    public boolean forEachKotlinOverride(@NotNull KtClass ktClass2, @NotNull List<? extends KtNamedDeclaration> members2, @NotNull SearchScope scope2, boolean searchDeeply, @NotNull Function2<? super PsiElement, ? super PsiElement, Boolean> processor2) {
        Intrinsics.checkNotNullParameter((Object)ktClass2, (String)"ktClass");
        Intrinsics.checkNotNullParameter(members2, (String)"members");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        return OverridersSearchUtilsKt.forEachKotlinOverride(ktClass2, members2, scope2, searchDeeply, processor2);
    }

    public boolean forEachOverridingMethod(@NotNull PsiMethod method, @NotNull SearchScope scope2, @NotNull Function1<? super PsiMethod, Boolean> processor2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        return OverridersSearchUtilsKt.forEachOverridingMethod(method, scope2, processor2);
    }

    @NotNull
    public List<PsiElement> findDeepestSuperMethodsNoWrapping(@NotNull PsiElement method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return OverridersSearchUtilsKt.findDeepestSuperMethodsNoWrapping(method);
    }

    @NotNull
    public List<PsiElement> findSuperMethodsNoWrapping(@NotNull PsiElement method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return OverridersSearchUtilsKt.findSuperMethodsNoWrapping(method);
    }

    @NotNull
    public Collection<KtTypeAlias> findTypeAliasByShortName(@NotNull String shortName, @NotNull Project project2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection collection = KotlinTypeAliasShortNameIndex.getInstance().get(shortName, project2, scope2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"KotlinTypeAliasShortName\u2026hortName, project, scope)");
        return collection;
    }

    public boolean isInProjectSource(@NotNull PsiElement element3, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return ProjectRootsUtil.isInProjectSource((PsiElement)element3, (boolean)includeScriptsOutsideSourceRoots);
    }

    public boolean isOverridable(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return PsiModificationUtilsKt.isOverridable((KtDeclaration)declaration2);
    }

    public boolean isInheritable(@NotNull KtClass ktClass2) {
        Intrinsics.checkNotNullParameter((Object)ktClass2, (String)"ktClass");
        return PsiModificationUtilsKt.isInheritable((KtClass)ktClass2);
    }

    @NotNull
    public String formatJavaOrLightMethod(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return RenderingUtilsKt.formatJavaOrLightMethod(method);
    }

    @NotNull
    public String formatClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        return RenderingUtilsKt.formatClass(classOrObject);
    }

    @Nullable
    public KtDeclaration expectedDeclarationIfAny(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return ExpectActualUtilKt.expectedDeclarationIfAny((KtDeclaration)declaration2);
    }

    public boolean isExpectDeclaration(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)declaration2);
    }

    public boolean canBeResolvedWithFrontEnd(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return JavaResolutionUtils.hasJavaResolutionFacade((PsiElement)element3);
    }

    @NotNull
    public KotlinSearchUsagesSupport.ConstructorCallHandle createConstructorHandle(@NotNull KtDeclaration ktDeclaration) {
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        return new KotlinConstructorCallLazyDescriptorHandle(ktDeclaration);
    }

    @NotNull
    public KotlinSearchUsagesSupport.ConstructorCallHandle createConstructorHandle(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        return new JavaConstructorCallLazyDescriptorHandle(psiMethod);
    }
}

