/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J5\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0004H\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinParameterProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "isToSearchInComments", "psiElement", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchInComments", "enabled", "kotlin.idea"})
public final class RenameKotlinParameterProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtParameter && ((KtParameter)element3).getOwnerFunction() instanceof KtFunction;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        return KotlinRefactoringSettings.Companion.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
    }

    public void setToSearchInComments(@NotNull PsiElement element3, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KotlinRefactoringSettings.Companion.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
    }

    public void findCollisions(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element3);
        if (!(psiNamedElement instanceof KtNamedDeclaration)) {
            psiNamedElement = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiNamedElement;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        SmartList collisions = new SmartList();
        RenameConflictUtilsKt.checkRedeclarations$default(declaration2, newName2, (List)collisions, null, null, 24, null);
        RenameConflictUtilsKt.checkOriginalUsagesRetargeting(declaration2, newName2, result2, (List)collisions);
        RenameConflictUtilsKt.checkNewNameUsagesRetargeting(declaration2, newName2, (List)collisions);
        Collection collection = result2;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)collisions));
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element3, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        if (!(element3 instanceof KtParameter)) {
            return super.findReferences(element3, searchScope, searchInCommentsAndStrings);
        }
        KtDeclarationWithBody ktDeclarationWithBody = ((KtParameter)element3).getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return super.findReferences(element3, searchScope, searchInCommentsAndStrings);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktDeclarationWithBody, (String)"element.ownerFunction\n  \u2026archInCommentsAndStrings)");
        KtDeclarationWithBody ownerFunction = ktDeclarationWithBody;
        SearchScope searchScope2 = ownerFunction.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"ownerFunction.useScope");
        SearchScope newScope = SearchUtilKt.or((SearchScope)searchScope, (SearchScope)searchScope2);
        return super.findReferences(element3, newScope, searchInCommentsAndStrings);
    }

    @Override
    public void renameElement(@NotNull PsiElement element3, @NotNull String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        super.renameElement(element3, newName2, usages2, listener2);
        UsageInfo[] $this$forEach$iv = usages2;
        boolean $i$f$forEach = false;
        UsageInfo[] usageInfoArray = $this$forEach$iv;
        int n = usageInfoArray.length;
        for (int i = 0; i < n; ++i) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = usageInfoArray[i];
            boolean bl = false;
            UsageInfo usageInfo = it;
            if (!(usageInfo instanceof KtResolvableCollisionUsageInfo)) {
                usageInfo = null;
            }
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = (KtResolvableCollisionUsageInfo)usageInfo;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }
}

