/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.DataContextUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.AbstractReferenceSubstitutionRenameHandler;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameByLabeledReferenceHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/AbstractReferenceSubstitutionRenameHandler;", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "kotlin.idea"})
public final class RenameByLabeledReferenceHandler
extends AbstractReferenceSubstitutionRenameHandler {
    @Override
    @Nullable
    protected PsiElement getElementToRename(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        KtSimpleNameExpression ktSimpleNameExpression = AbstractReferenceSubstitutionRenameHandler.Companion.getReferenceExpression(dataContext);
        if (!(ktSimpleNameExpression instanceof KtLabelReferenceExpression)) {
            ktSimpleNameExpression = null;
        }
        KtLabelReferenceExpression ktLabelReferenceExpression = (KtLabelReferenceExpression)ktSimpleNameExpression;
        if (ktLabelReferenceExpression == null) {
            return null;
        }
        KtLabelReferenceExpression refExpr = ktLabelReferenceExpression;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)refExpr), (BodyResolveMode)BodyResolveMode.PARTIAL);
        Object object = context2.get((ReadOnlySlice)BindingContext.LABEL_TARGET, (Object)refExpr);
        if (!(object instanceof KtExpression)) {
            object = null;
        }
        KtExpression ktExpression = (KtExpression)object;
        if (ktExpression == null) {
            return null;
        }
        KtExpression labelTarget = ktExpression;
        KtLabeledExpression labeledParent = KtPsiUtilKt.getLabeledParent((KtExpression)labelTarget, (String)refExpr.getReferencedName());
        if (!(labelTarget instanceof KtFunction) || labeledParent != null) {
            return (PsiElement)labeledParent;
        }
        KtSimpleNameExpression ktSimpleNameExpression2 = ReferenceUtilKt.getCalleeByLambdaArgument((KtFunction)((KtFunction)labelTarget));
        if (ktSimpleNameExpression2 == null) {
            return null;
        }
        KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression2;
        Object object2 = context2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)calleeExpression2);
        if (!(object2 instanceof FunctionDescriptor)) {
            object2 = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)object2;
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        return DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(DataContextUtilsKt.getProject(dataContext), (DeclarationDescriptor)descriptor2);
    }

    public RenameByLabeledReferenceHandler() {
        super((RenameHandler)new KotlinVariableInplaceRenameHandler());
    }
}

