/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlinePropertyProcessor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\tH\u0014J\u0006\u0010\u0012\u001a\u00020\tR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlinePropertyDialog;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "reference", "Lcom/intellij/psi/PsiReference;", "assignmentToDelete", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "withPreview", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lcom/intellij/psi/PsiReference;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;ZLcom/intellij/openapi/editor/Editor;)V", "simpleLocal", "doAction", "", "doHelpAction", "isInlineThis", "shouldBeShown", "kotlin.idea"})
public final class KotlinInlinePropertyDialog
extends AbstractKotlinInlineDialog<KtProperty> {
    private final boolean simpleLocal;
    private final KtBinaryExpression assignmentToDelete;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldBeShown() {
        if (!this.simpleLocal) return true;
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        if (!editorSettingsExternalizable.isShowInlineLocalDialog()) return false;
        return true;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.inlineVariable");
    }

    protected boolean isInlineThis() {
        return KotlinRefactoringSettings.Companion.getInstance().INLINE_LOCAL_THIS;
    }

    public void doAction() {
        KtProperty ktProperty = (KtProperty)this.getDeclaration();
        PsiReference psiReference = this.getReference();
        boolean bl = this.isInlineThisOnly();
        boolean bl2 = !this.isInlineThisOnly() && !this.isKeepTheDeclaration();
        PsiElement psiElement2 = ((KtProperty)this.getDeclaration()).getParent();
        if (!(psiElement2 instanceof KtWhenExpression)) {
            psiElement2 = null;
        }
        KtWhenExpression ktWhenExpression = (KtWhenExpression)psiElement2;
        boolean bl3 = Intrinsics.areEqual((Object)(ktWhenExpression != null ? ktWhenExpression.getSubjectVariable() : null), (Object)((KtProperty)this.getDeclaration()));
        Editor editor2 = this.getEditor();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.invokeRefactoring(new KotlinInlinePropertyProcessor(ktProperty, psiReference, bl, bl2, bl3, editor2, this.assignmentToDelete, project2));
        KotlinRefactoringSettings settings = KotlinRefactoringSettings.Companion.getInstance();
        JRadioButton jRadioButton = this.myRbInlineThisOnly;
        Intrinsics.checkNotNullExpressionValue((Object)jRadioButton, (String)"myRbInlineThisOnly");
        if (jRadioButton.isEnabled()) {
            JRadioButton jRadioButton2 = this.myRbInlineAll;
            Intrinsics.checkNotNullExpressionValue((Object)jRadioButton2, (String)"myRbInlineAll");
            if (jRadioButton2.isEnabled()) {
                settings.INLINE_LOCAL_THIS = this.isInlineThisOnly();
            }
        }
    }

    public KotlinInlinePropertyDialog(@NotNull KtProperty property2, @Nullable PsiReference reference2, @Nullable KtBinaryExpression assignmentToDelete, boolean withPreview, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        super((KtNamedDeclaration)property2, reference2, editor2);
        this.assignmentToDelete = assignmentToDelete;
        this.simpleLocal = ((KtProperty)this.getDeclaration()).isLocal() && (reference2 == null || this.getOccurrencesNumber() == 1);
        this.setPreviewResults(withPreview && this.shouldBeShown());
        if (this.simpleLocal) {
            this.setDoNotAskOption(new DialogWrapper.DoNotAskOption(){

                public boolean isToBeShown() {
                    EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                    return editorSettingsExternalizable.isShowInlineLocalDialog();
                }

                public void setToBeShown(boolean value, int exitCode) {
                    EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
                    editorSettingsExternalizable.setShowInlineLocalDialog(value);
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return KotlinBundle.message("message.do.not.show.for.local.variables.in.future", new Object[0]);
                }
            });
        }
        this.init();
    }

    public /* synthetic */ KotlinInlinePropertyDialog(KtProperty ktProperty, PsiReference psiReference, KtBinaryExpression ktBinaryExpression, boolean bl, Editor editor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(ktProperty, psiReference, ktBinaryExpression, bl, editor2);
    }
}

