/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineFunctionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.InlineUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineNamedFunctionDialog;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineNamedFunctionHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineFunctionHandler;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "()V", "canInlineKotlinFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "inlineKotlinFunction", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "includesCallOf", "Lorg/jetbrains/kotlin/psi/KtExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isRecursive", "kotlin.idea"})
public final class KotlinInlineNamedFunctionHandler
extends AbstractKotlinInlineFunctionHandler<KtNamedFunction> {
    @Override
    public boolean canInlineKotlinFunction(@NotNull KtFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof KtNamedFunction && !ExpressionExtKt.isAnonymousFunction((KtNamedFunction)function2);
    }

    @Override
    public void inlineKotlinFunction(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Editor editor3 = editor2;
        PsiReference nameReference = editor3 != null ? InlineUtilsKt.findSimpleNameReference(editor3) : null;
        boolean recursive = this.isRecursive(function2);
        if (recursive && nameReference == null) {
            String message2;
            String string = message2 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message("text.inline.recursive.function.is.supported.only.on.references", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
            this.showErrorHint(project2, editor2, string);
            return;
        }
        Editor editor4 = editor2;
        boolean bl = recursive;
        KotlinInlineNamedFunctionDialog dialog2 = new KotlinInlineNamedFunctionDialog(function2, nameReference, editor4, bl);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            dialog2.show();
        } else {
            dialog2.doAction();
            dialog2.close(0, true);
        }
    }

    private final boolean isRecursive(KtNamedFunction $this$isRecursive) {
        boolean bl;
        BindingContext context2 = ResolutionUtils.analyzeWithContent((KtDeclaration)((KtDeclaration)$this$isRecursive));
        KtExpression ktExpression = $this$isRecursive.getBodyExpression();
        if (ktExpression != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)$this$isRecursive);
            if (simpleFunctionDescriptor == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"context[BindingContext.F\u2026ON, this] ?: return false");
            bl = this.includesCallOf(ktExpression, (FunctionDescriptor)simpleFunctionDescriptor, context2);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean includesCallOf(KtExpression $this$includesCallOf, FunctionDescriptor descriptor2, BindingContext context2) {
        void $this$anyDescendantOfType$iv;
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$includesCallOf), (BindingContext)context2);
        CallableDescriptor refDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (Intrinsics.areEqual((Object)descriptor2, (Object)refDescriptor)) return true;
        PsiElement psiElement2 = (PsiElement)$this$includesCallOf;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>($this$includesCallOf, descriptor2, context2){
            final /* synthetic */ KtExpression $this_includesCallOf;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ BindingContext $context;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it == this.$this_includesCallOf) return false;
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)this.$context);
                if (!Intrinsics.areEqual((Object)this.$descriptor, (Object)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null))) return false;
                return true;
            }
            {
                this.$this_includesCallOf = ktExpression;
                this.$descriptor = functionDescriptor2;
                this.$context = bindingContext2;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }
}

