/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.sealedSubClassToObject;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.ConvertSecondaryConstructorToPrimaryIntention;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J/\u0010\u0010\u001a!\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b\u0013\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u00140\u00112\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0014\u0010\u0017\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u00020\u0004*\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00112\u0006\u0010\r\u001a\u00020\u000bH\u0002J&\u0010\u001b\u001a\u00020\u0004*\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00112\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "changeDeclaration", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "changeInstances", "klass", "getFamilyName", "", "mapReferencesByLanguage", "", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/NotNull;", "", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "changeToObject", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "replaceJava", "replaceKotlin", "transformToObject", "Companion", "kotlin.idea"})
public final class ConvertSealedSubClassToObjectFix
implements LocalQuickFix {
    @Nullable
    private static final Language JAVA_LANG;
    @Nullable
    private static final Language KOTLIN_LANG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("convert.sealed.sub.class.to.object.fix.family.name", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
        PsiElement psiElement3 = psiElement2;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
        if (ktClass2 == null) {
            return;
        }
        KtClass klass2 = ktClass2;
        this.changeInstances(klass2);
        this.changeDeclaration(klass2);
    }

    private final void changeDeclaration(KtClass element3) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
        this.changeToObject(element3, factory2);
        this.transformToObject(element3, factory2);
    }

    private final void changeToObject(KtClass $this$changeToObject, KtPsiFactory factory2) {
        block2: {
            Iterable $this$forEach$iv = $this$changeToObject.getSecondaryConstructors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                boolean bl = false;
                new ConvertSecondaryConstructorToPrimaryIntention().applyTo(it, null);
            }
            KtPrimaryConstructor ktPrimaryConstructor = $this$changeToObject.getPrimaryConstructor();
            if (ktPrimaryConstructor != null) {
                ktPrimaryConstructor.delete();
            }
            PsiElement psiElement2 = $this$changeToObject.getClassOrInterfaceKeyword();
            if (psiElement2 == null) break block2;
            KtKeywordToken ktKeywordToken = KtTokens.OBJECT_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.OBJECT_KEYWORD");
            String string = ktKeywordToken.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KtTokens.OBJECT_KEYWORD.value");
            psiElement2.replace((PsiElement)factory2.createExpression(string));
        }
    }

    private final void transformToObject(KtClass $this$transformToObject, KtPsiFactory factory2) {
        String string = $this$transformToObject.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        $this$transformToObject.replace((PsiElement)factory2.createObject(string));
    }

    private final void changeInstances(KtClass klass2) {
        Map<Language, List<PsiElement>> map2 = this.mapReferencesByLanguage(klass2);
        boolean bl = false;
        boolean bl2 = false;
        Map<Language, List<PsiElement>> $this$apply = map2;
        boolean bl3 = false;
        this.replaceKotlin($this$apply, klass2);
        this.replaceJava($this$apply, klass2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Language, List<PsiElement>> mapReferencesByLanguage(KtClass klass2) {
        void $this$groupByTo$iv$iv;
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)klass2));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(klass)");
        Iterable $this$groupBy$iv = (Iterable)query;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            PsiReference it2 = (PsiReference)element$iv$iv;
            boolean $i$a$-groupBy-ConvertSealedSubClassToObjectFix$mapReferencesByLanguage$32 = false;
            PsiReference psiReference = it2;
            Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"it");
            PsiElement psiElement2 = psiReference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.element");
            Language key$iv$iv = psiElement2.getLanguage();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            PsiReference $i$a$-groupBy-ConvertSealedSubClassToObjectFix$mapReferencesByLanguage$32 = (PsiReference)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            PsiElement psiElement3 = v4.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it.element");
            PsiElement psiElement4 = psiElement3.getParent();
            list.add(psiElement4);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceKotlin(Map<Language, ? extends List<? extends PsiElement>> $this$replaceKotlin, KtClass klass2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map<Language, ? extends List<? extends PsiElement>> map2 = $this$replaceKotlin;
        Language language = KOTLIN_LANG;
        boolean bl = false;
        List<? extends PsiElement> list = map2.get(language);
        if (list == null) {
            return;
        }
        List<? extends PsiElement> list2 = list;
        KtExpression singletonCall2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)klass2), (boolean)false, (int)2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(klass2){
            final /* synthetic */ KtClass $klass;

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                Name name2 = this.$klass.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"klass.nameAsSafeName");
                $this$buildExpression.appendName(name2);
            }
            {
                this.$klass = ktClass2;
                super(1);
            }
        }), (int)1, null);
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
            if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl3 = false;
            it.replace((PsiElement)singletonCall2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceJava(Map<Language, ? extends List<? extends PsiElement>> $this$replaceJava, KtClass klass2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map<Language, ? extends List<? extends PsiElement>> map2 = $this$replaceJava;
        Language language = JAVA_LANG;
        boolean bl = false;
        List<? extends PsiElement> list = map2.get(language);
        if (list == null) {
            return;
        }
        List<? extends PsiElement> list2 = list;
        PsiElement psiElement2 = (PsiElement)CollectionsKt.firstOrNull(list2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement first = psiElement2;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)klass2.getProject());
        PsiExpression psiExpression = elementFactory.createExpressionFromText(klass2.getName() + ".INSTANCE", first);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"elementFactory.createExp\u2026s.name}.INSTANCE\", first)");
        PsiExpression javaSingletonCall = psiExpression;
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
            if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)JavaElementType.NEW_EXPRESSION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl3 = false;
            PsiElement psiElement3 = it.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it.parent");
            ASTNode aSTNode = psiElement3.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.parent.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.EXPRESSION_STATEMENT)) {
                it.delete();
                continue;
            }
            it.replace((PsiElement)javaSingletonCall);
        }
    }

    static {
        Companion = new Companion(null);
        JAVA_LANG = Language.findLanguageByID((String)"JAVA");
        KOTLIN_LANG = Language.findLanguageByID((String)"kotlin");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix$Companion;", "", "()V", "JAVA_LANG", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/Nullable;", "getJAVA_LANG", "()Lcom/intellij/lang/Language;", "KOTLIN_LANG", "getKOTLIN_LANG", "kotlin.idea"})
    public static final class Companion {
        @Nullable
        public final Language getJAVA_LANG() {
            return JAVA_LANG;
        }

        @Nullable
        public final Language getKOTLIN_LANG() {
            return KOTLIN_LANG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

