/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProfileKt;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a \u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\f"}, d2={"applicableMigrationTools", "", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "migrationInfo", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "applicableMigrationToolsImpl", "createMigrationProfile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "managerEx", "Lcom/intellij/codeInspection/ex/InspectionManagerEx;", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class KotlinMigrationProfileKt {
    @NotNull
    public static final InspectionProfileImpl createMigrationProfile(@NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement2, @Nullable MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)managerEx, (String)"managerEx");
        InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"InspectionProfileManager.getInstance()");
        InspectionProfileImpl inspectionProfileImpl = inspectionProfileManager.getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"InspectionProfileManager\u2026Instance().currentProfile");
        InspectionProfileImpl rootProfile = inspectionProfileImpl;
        List<InspectionToolWrapper<?, ?>> migrationFixWrappers = KotlinMigrationProfileKt.applicableMigrationToolsImpl(migrationInfo);
        LinkedHashSet allWrappers = new LinkedHashSet();
        for (InspectionToolWrapper<?, ?> toolWrapper : migrationFixWrappers) {
            allWrappers.add(toolWrapper);
            rootProfile.collectDependentInspections(toolWrapper, (Set)allWrappers, managerEx.getProject());
        }
        String string = KotlinBundle.message("inspection.migration.profile.name", new Object[0]);
        Project project2 = managerEx.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"managerEx.project");
        InspectionProfileImpl model2 = InspectionProfileKt.createSimple((String)string, (Project)project2, migrationFixWrappers);
        try {
            Element element3 = new Element("toCopy");
            for (InspectionToolWrapper<?, ?> wrapper : migrationFixWrappers) {
                InspectionToolWrapper tw;
                wrapper.getTool().writeSettings(element3);
                Intrinsics.checkNotNull((Object)(psiElement2 == null ? model2.getInspectionTool(wrapper.getShortName(), managerEx.getProject()) : model2.getInspectionTool(wrapper.getShortName(), psiElement2)));
                Intrinsics.checkNotNullExpressionValue((Object)tw, (String)"(if (psiElement == null)\u2026shortName, psiElement))!!");
                tw = tw;
                tw.getTool().readSettings(element3);
            }
        }
        catch (WriteExternalException writeExternalException) {
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return model2;
    }

    public static /* synthetic */ InspectionProfileImpl createMigrationProfile$default(InspectionManagerEx inspectionManagerEx, PsiElement psiElement2, MigrationInfo migrationInfo, int n, Object object) {
        if ((n & 4) != 0) {
            migrationInfo = null;
        }
        return KotlinMigrationProfileKt.createMigrationProfile(inspectionManagerEx, psiElement2, migrationInfo);
    }

    @NotNull
    public static final List<InspectionToolWrapper<?, ?>> applicableMigrationTools(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return KotlinMigrationProfileKt.applicableMigrationToolsImpl(migrationInfo);
    }

    private static final List<InspectionToolWrapper<?, ?>> applicableMigrationToolsImpl(MigrationInfo migrationInfo) {
        InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"InspectionProfileManager.getInstance()");
        InspectionProfileImpl inspectionProfileImpl = inspectionProfileManager.getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"InspectionProfileManager\u2026Instance().currentProfile");
        InspectionProfileImpl rootProfile = inspectionProfileImpl;
        List list = rootProfile.getAllTools();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rootProfile.allTools");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)applicableMigrationToolsImpl.1.INSTANCE), (Function1)new Function1<InspectionToolWrapper<?, ?>, Boolean>(migrationInfo){
            final /* synthetic */ MigrationInfo $migrationInfo;

            public final boolean invoke(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
                Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
                InspectionProfileEntry tool = toolWrapper.getTool();
                return tool instanceof MigrationFix && (this.$migrationInfo == null || ((MigrationFix)tool).isApplicable(this.$migrationInfo));
            }
            {
                this.$migrationInfo = migrationInfo;
                super(1);
            }
        }));
    }
}

