/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.migration;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.migration.CodeInspectionAction;
import org.jetbrains.kotlin.idea.migration.CodeMigrationToggleAction;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/migration/CodeMigrationAction;", "Lorg/jetbrains/kotlin/idea/migration/CodeInspectionAction;", "()V", "getHelpTopic", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "kotlin.idea"})
public final class CodeMigrationAction
extends CodeInspectionAction {
    @NotNull
    public static final String ACTION_ID = "KotlinCodeMigration";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project2 = e.getProject();
        if (project2 != null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(CodeMigrationToggleAction.Companion.isEnabled(project2));
        }
    }

    @Override
    @NotNull
    protected String getHelpTopic() {
        return "reference.dialogs.cleanup.scope";
    }

    public CodeMigrationAction() {
        super(KotlinBundle.message("inspection.migration.title", new Object[0]), KotlinBundle.message("inspection.migration.title", new Object[0]));
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/migration/CodeMigrationAction$Companion;", "", "()V", "ACTION_ID", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

