/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.intentions.AddMissingDestructuringIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0002J2\u0010\u000f\u001a(\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u0001 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00130\u0010*\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddMissingDestructuringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "primaryParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "", "kotlin.idea"})
public final class AddMissingDestructuringIntention
extends SelfTargetingIntention<KtDestructuringDeclaration> {
    public boolean isApplicableTo(@NotNull KtDestructuringDeclaration element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        int entriesCount = element3.getEntries().size();
        ClassDescriptor classDescriptor = this.classDescriptor(element3);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (!classDescriptor2.isData()) {
            return false;
        }
        List<ValueParameterDescriptor> list = this.primaryParameters(classDescriptor2);
        if (list == null) {
            return false;
        }
        List<ValueParameterDescriptor> primaryParameters = list;
        return primaryParameters.size() > entriesCount;
    }

    public void applyTo(@NotNull KtDestructuringDeclaration element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        List list = element3.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.entries");
        List entries = list;
        Object object = this.classDescriptor(element3);
        if (object == null || (object = this.primaryParameters((ClassDescriptor)object)) == null) {
            return;
        }
        Object primaryParameters = object;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"element.parent.parent");
        CollectingNameValidator nameValidator2 = new CollectingNameValidator(null, (Function1)new NewDeclarationNameValidator(psiElement3, null, NewDeclarationNameValidator.Target.VARIABLES, null, 8, null), 1, null);
        int entriesSize = entries.size();
        String newEntries2 = CollectionsKt.joinToString$default((Iterable)entries, null, null, (CharSequence)(entriesSize == 0 ? "" : ", "), (int)0, null, (Function1)applyTo.newEntries.1.INSTANCE, (int)27, null) + SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)primaryParameters)), (int)entriesSize), null, null, null, (int)0, null, (Function1)((Function1)new Function1<ValueParameterDescriptor, CharSequence>(nameValidator2){
            final /* synthetic */ CollectingNameValidator $nameValidator;

            @NotNull
            public final CharSequence invoke(ValueParameterDescriptor it) {
                ValueParameterDescriptor valueParameterDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"it");
                String string = valueParameterDescriptor.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name.asString()");
                return KotlinNameSuggester.INSTANCE.suggestNameByName(string, (Function1)this.$nameValidator);
            }
            {
                this.$nameValidator = collectingNameValidator;
                super(1);
            }
        }), (int)31, null);
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.initializer ?: return");
        KtExpression initializer2 = ktExpression;
        KtDestructuringDeclaration newDestructuringDeclaration = CreateByPatternKt.createDestructuringDeclarationByPattern$default((KtPsiFactory)factory2, (String)(element3.isVar() ? "var ($0) = $1" : "val ($0) = $1"), (Object[])new Object[]{newEntries2, initializer2}, (boolean)false, (int)4, null);
        element3.replace((PsiElement)newDestructuringDeclaration);
    }

    private final ClassDescriptor classDescriptor(KtDestructuringDeclaration $this$classDescriptor) {
        KtExpression ktExpression;
        block6: {
            block5: {
                ktExpression = $this$classDescriptor.getInitializer();
                if (ktExpression == null) break block5;
                KtExpression ktExpression2 = ktExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtExpression it = ktExpression2;
                boolean bl3 = false;
                KtExpression ktExpression3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"it");
                ktExpression = ResolutionUtils.analyze$default((KtElement)((KtElement)ktExpression3), null, (int)1, null).getType(it);
                if (ktExpression != null) break block6;
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"initializer?.let { it.an\u2026Type(it) } ?: return null");
        KtExpression type2 = ktExpression;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        return classDescriptor;
    }

    private final List<ValueParameterDescriptor> primaryParameters(ClassDescriptor $this$primaryParameters) {
        Object v2;
        block1: {
            Collection collection = $this$primaryParameters.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"constructors");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                boolean bl = false;
                ClassConstructorDescriptor classConstructorDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptor, (String)"it");
                if (!classConstructorDescriptor.isPrimary()) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = v2;
        return classConstructorDescriptor != null ? classConstructorDescriptor.getValueParameters() : null;
    }

    public AddMissingDestructuringIntention() {
        super(KtDestructuringDeclaration.class, KotlinBundle.lazyMessage("add.missing.component", new Object[0]), null, 4, null);
    }
}

