/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceIndexLoopWithCollectionLoopQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallsInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "rangeFunctions", "", "", "getRangeFunctions", "()Ljava/util/Set;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "visitIndicesRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitRange", "expression", "left", "right", "method", "kotlin.idea"})
public final class ReplaceManualRangeWithIndicesCallsInspection
extends AbstractKotlinInspection {
    @NotNull
    private final Set<String> rangeFunctions = SetsKt.setOf((Object[])new String[]{"until", "rangeTo"});

    @NotNull
    public final Set<String> getRangeFunctions() {
        return this.rangeFunctions;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ ReplaceManualRangeWithIndicesCallsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression) {
                Object v1;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                    Iterable iterable = this.this$0.getRangeFunctions();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        String it = (String)t;
                        boolean bl3 = false;
                        KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
                        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"binaryExpression.operationReference");
                        if (!Intrinsics.areEqual((Object)it, (Object)ktOperationReferenceExpression.getText())) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                String find2 = v1;
                if (Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.RANGE) || find2 != null) {
                    String string = find2;
                    if (string == null) {
                        string = "rangeTo";
                    }
                    String operator = string;
                    KtExpression ktExpression = (KtExpression)binaryExpression;
                    KtExpression ktExpression2 = binaryExpression.getLeft();
                    if (ktExpression2 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"binaryExpression.left ?: return");
                    KtExpression ktExpression3 = binaryExpression.getRight();
                    if (ktExpression3 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"binaryExpression.right ?: return");
                    ReplaceManualRangeWithIndicesCallsInspection.access$visitRange(this.this$0, this.$holder, ktExpression, ktExpression2, ktExpression3, operator);
                }
            }

            public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                Object v1;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Iterable iterable = this.this$0.getRangeFunctions();
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        String it = (String)t;
                        boolean bl3 = false;
                        KtExpression ktExpression = expression2.getSelectorExpression();
                        if (!Intrinsics.areEqual((Object)it, (Object)(ktExpression != null ? ktExpression.getText() : null))) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                String find2 = v1;
                if (find2 != null) {
                    PsiElement psiElement2 = expression2.getParent();
                    if (!(psiElement2 instanceof KtCallExpression)) {
                        psiElement2 = null;
                    }
                    KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
                    if (ktCallExpression == null) {
                        return;
                    }
                    KtCallExpression call = ktCallExpression;
                    List list = call.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call.valueArguments");
                    KtExpression ktExpression = ((KtValueArgument)CollectionsKt.first((List)list)).getArgumentExpression();
                    if (ktExpression == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"call.valueArguments.firs\u2026entExpression() ?: return");
                    KtExpression firstArg = ktExpression;
                    ReplaceManualRangeWithIndicesCallsInspection.access$visitRange(this.this$0, this.$holder, (KtExpression)expression2, expression2.getReceiverExpression(), firstArg, find2);
                }
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final void visitRange(ProblemsHolder holder, KtExpression expression2, KtExpression left, KtExpression right, String method) {
        block4: {
            block3: {
                block2: {
                    if (!Intrinsics.areEqual((Object)method, (Object)"until")) break block2;
                    Integer n = ReplaceManualRangeWithIndicesCallsInspectionKt.access$toIntConstant(left);
                    if (n != null && n == 0 && ReplaceManualRangeWithIndicesCallsInspectionKt.receiverIfIsSizeOrLengthCall(right) != null) break block3;
                }
                if (!Intrinsics.areEqual((Object)method, (Object)"rangeTo")) break block4;
                Integer n = ReplaceManualRangeWithIndicesCallsInspectionKt.access$toIntConstant(left);
                if (n == null || n != 0 || ReplaceManualRangeWithIndicesCallsInspectionKt.receiverIfIsSizeOrLengthMinusOneCall(right) == null) break block4;
            }
            this.visitIndicesRange(holder, expression2);
        }
    }

    private final void visitIndicesRange(ProblemsHolder holder, KtExpression range) {
        PsiElement psiElement2 = range.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"range.parent");
        PsiElement parent2 = psiElement2.getParent();
        if (parent2 instanceof KtForExpression) {
            KtArrayAccessExpression arrayAccess;
            PsiElement psiElement3;
            KtParameter ktParameter = ((KtForExpression)parent2).getLoopParameter();
            if (ktParameter == null || (ktParameter = ktParameter.getOriginalElement()) == null) {
                return;
            }
            KtParameter paramElement = ktParameter;
            Query query = ReferencesSearch.search((PsiElement)paramElement);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(paramElement)");
            PsiReference psiReference = (PsiReference)CollectionsKt.singleOrNull((Iterable)((Iterable)query));
            Object usageElement = psiReference != null ? psiReference.getElement() : null;
            PsiElement psiElement4 = usageElement;
            if (!((psiElement4 != null && (psiElement4 = psiElement4.getParent()) != null ? psiElement4.getParent() : (psiElement3 = null)) instanceof KtArrayAccessExpression)) {
                psiElement3 = null;
            }
            if ((arrayAccess = (KtArrayAccessExpression)psiElement3) != null) {
                PsiElement arrayAccessParent;
                List list = arrayAccess.getIndexExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"arrayAccess.indexExpressions");
                if (Intrinsics.areEqual((Object)((KtExpression)CollectionsKt.singleOrNull((List)list)), (Object)usageElement) && (!((arrayAccessParent = arrayAccess.getParent()) instanceof KtBinaryExpression) || Intrinsics.areEqual((Object)((KtBinaryExpression)arrayAccessParent).getLeft(), (Object)arrayAccess) ^ true || !KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)arrayAccessParent).getOperationToken()))) {
                    holder.registerProblem((PsiElement)range, KotlinBundle.message("for.loop.over.indices.could.be.replaced.with.loop.over.elements", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceIndexLoopWithCollectionLoopQuickFix()});
                    return;
                }
            }
        }
        holder.registerProblem((PsiElement)range, KotlinBundle.message("range.could.be.replaced.with.indices.call", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceManualRangeWithIndicesCallQuickFix()});
    }

    public static final /* synthetic */ void access$visitRange(ReplaceManualRangeWithIndicesCallsInspection $this, ProblemsHolder holder, KtExpression expression2, KtExpression left, KtExpression right, String method) {
        $this.visitRange(holder, expression2, left, right, method);
    }
}

