/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.ProjectTopics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SoftFactoryMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.framework.LibraryEffectiveKindProvider;
import org.jetbrains.kotlin.idea.framework.LibraryEffectiveKindProviderImpl;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/framework/LibraryEffectiveKindProviderImpl;", "Lorg/jetbrains/kotlin/idea/framework/LibraryEffectiveKindProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "effectiveKindMap", "org/jetbrains/kotlin/idea/framework/LibraryEffectiveKindProviderImpl$effectiveKindMap$1", "Lorg/jetbrains/kotlin/idea/framework/LibraryEffectiveKindProviderImpl$effectiveKindMap$1;", "getEffectiveKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "kotlin.idea"})
public final class LibraryEffectiveKindProviderImpl
implements LibraryEffectiveKindProvider {
    private final effectiveKindMap.1 effectiveKindMap;

    @Nullable
    public PersistentLibraryKind<?> getEffectiveKind(@NotNull LibraryEx library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library.isDisposed()) {
            return null;
        }
        PersistentLibraryKind kind = library.getKind();
        return kind instanceof KotlinLibraryKind ? kind : (PersistentLibraryKind)this.effectiveKindMap.get(library);
    }

    public LibraryEffectiveKindProviderImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.effectiveKindMap = new SoftFactoryMap<LibraryEx, PersistentLibraryKind<?>>(){

            @Nullable
            protected PersistentLibraryKind<?> create(@NotNull LibraryEx key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                VirtualFile[] virtualFileArray = key.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"key.getFiles(OrderRootType.CLASSES)");
                return LibraryKindsKt.detectLibraryKind((VirtualFile[])virtualFileArray);
            }
        };
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                effectiveKindMap.clear();
            }
        });
    }
}

