/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class PluginStartupApplicationService {
    private String aliveFlagPath;

    public static PluginStartupApplicationService getInstance() {
        return (PluginStartupApplicationService)ApplicationManager.getApplication().getService(PluginStartupApplicationService.class);
    }

    public synchronized String getAliveFlagPath() {
        if (this.aliveFlagPath == null) {
            try {
                Path flagFile = Files.createTempFile("kotlin-idea-", "-is-running", new FileAttribute[0]);
                flagFile.toFile().deleteOnExit();
                this.aliveFlagPath = flagFile.toAbsolutePath().toString();
            }
            catch (IOException e) {
                this.aliveFlagPath = "";
            }
        }
        return this.aliveFlagPath;
    }

    public synchronized void resetAliveFlag() {
        File flagFile;
        if (this.aliveFlagPath != null && (flagFile = new File(this.aliveFlagPath)).exists() && flagFile.delete()) {
            this.aliveFlagPath = null;
        }
    }
}

