/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpNamedGroupRefImpl
extends RegExpElementImpl
implements RegExpNamedGroupRef {
    private static final TokenSet RUBY_GROUP_REF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.RUBY_NAMED_GROUP_REF, RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF, RegExpTT.RUBY_NAMED_GROUP_CALL, RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL});

    public RegExpNamedGroupRefImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpNamedGroupRef(this);
    }

    @Override
    @Nullable
    public RegExpGroup resolve() {
        return (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)this.getContainingFile()).filter(RegExpGroup.class).filter(group -> group.isAnyNamedGroup() && Objects.equals(this.getGroupName(), group.getGroupName())).first();
    }

    @Override
    @Nullable
    public String getGroupName() {
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public boolean isPythonNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.PYTHON_NAMED_GROUP_REF) != null;
    }

    @Override
    public boolean isRubyNamedGroupRef() {
        ASTNode node = this.getNode();
        return node.findChildByType(RUBY_GROUP_REF_TOKENS) != null;
    }

    @Override
    public boolean isNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.RUBY_NAMED_GROUP_REF) != null;
    }

    @Override
    public PsiReference getReference() {
        if (this.getNode().findChildByType(RegExpTT.NAME) == null) {
            return null;
        }
        return new PsiReference(){

            @NotNull
            public PsiElement getElement() {
                return RegExpNamedGroupRefImpl.this;
            }

            @NotNull
            public TextRange getRangeInElement() {
                ASTNode nameNode = RegExpNamedGroupRefImpl.this.getNode().findChildByType(RegExpTT.NAME);
                assert (nameNode != null);
                int startOffset = RegExpNamedGroupRefImpl.this.getNode().getFirstChildNode().getTextLength();
                return new TextRange(startOffset, startOffset + nameNode.getTextLength());
            }

            public PsiElement resolve() {
                return RegExpNamedGroupRefImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                return this.getRangeInElement().substring(RegExpNamedGroupRefImpl.this.getText());
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                throw new UnsupportedOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                throw new UnsupportedOperationException();
            }

            public boolean isReferenceTo(@NotNull PsiElement element2) {
                return this.resolve() == element2;
            }

            public Object @NotNull [] getVariants() {
                return SyntaxTraverser.psiTraverser((PsiElement)RegExpNamedGroupRefImpl.this.getContainingFile()).filter(RegExpGroup.class).filter(RegExpGroup::isAnyNamedGroup).toArray((Object[])new RegExpGroup[0]);
            }

            public boolean isSoft() {
                return false;
            }
        };
    }
}

