/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbListener;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import com.intellij.xml.breadcrumbs.PsiBreadcrumbs;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BreadcrumbsPanel
extends JComponent
implements Disposable {
    private static final Logger LOG = Logger.getInstance(BreadcrumbsPanel.class);
    final PsiBreadcrumbs breadcrumbs = new PsiBreadcrumbs();
    protected final Project myProject;
    protected Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    protected boolean myUserCaretChange = true;
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, (JComponent)((Object)this.breadcrumbs));
    private final List<BreadcrumbListener> myBreadcrumbListeners = new ArrayList<BreadcrumbListener>();
    private final Update myUpdate = new Update(this){

        public void run() {
            BreadcrumbsPanel.this.updateCrumbsAsync();
        }

        public boolean canEat(Update update2) {
            return true;
        }
    };
    private static final Key<BreadcrumbsPanel> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");
    private static final Iterable<? extends Crumb> EMPTY_BREADCRUMBS = Collections.emptyList();

    public BreadcrumbsPanel(@NotNull Editor editor) {
        this.myEditor = editor;
        BreadcrumbsPanel.putBreadcrumbsComponent(this.myEditor, this);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addPropertyChangeListener(this::updateEditorFont, this);
        }
        Project project = editor.getProject();
        assert (project != null);
        this.myProject = project;
        FileStatusManager manager = FileStatusManager.getInstance((Project)project);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsPanel.this.queueUpdate();
            }
        }, (Disposable)this);
        CaretListener caretListener2 = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (BreadcrumbsPanel.this.myUserCaretChange) {
                    BreadcrumbsPanel.this.queueUpdate();
                }
                BreadcrumbsPanel.this.myUserCaretChange = true;
            }
        };
        editor.getCaretModel().addCaretListener(caretListener2, (Disposable)this);
        this.breadcrumbs.onHover(this::itemHovered);
        this.breadcrumbs.onSelect(this::itemSelected);
        this.breadcrumbs.setFont(BreadcrumbsPanel.getNewFont(this.myEditor));
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)((Object)this.breadcrumbs), (boolean)true);
        pane2.setVerticalScrollBarPolicy(21);
        pane2.getHorizontalScrollBar().setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add("Center", pane2);
        EditorGutter gutter = editor.getGutter();
        if (gutter instanceof EditorGutterComponentEx) {
            final EditorGutterComponentEx gutterComponent = (EditorGutterComponentEx)gutter;
            MouseEventAdapter<EditorGutterComponentEx> mouseListener = new MouseEventAdapter<EditorGutterComponentEx>(gutterComponent){

                @NotNull
                protected MouseEvent convert(@NotNull MouseEvent event) {
                    return 4.convert((MouseEvent)event, (Component)gutterComponent);
                }
            };
            ComponentAdapter resizeListener = new ComponentAdapter(){

                @Override
                @DirtyUI
                public void componentResized(ComponentEvent event) {
                    BreadcrumbsPanel.this.breadcrumbs.updateBorder(BreadcrumbsPanel.this.getLeftOffset());
                    BreadcrumbsPanel.this.breadcrumbs.setFont(BreadcrumbsPanel.getNewFont(BreadcrumbsPanel.this.myEditor));
                }
            };
            this.addComponentListener(resizeListener);
            gutterComponent.addComponentListener(resizeListener);
            this.breadcrumbs.addMouseListener((MouseListener)mouseListener);
            Disposer.register((Disposable)this, () -> this.lambda$new$0(resizeListener, gutterComponent, (MouseEventAdapter)mouseListener));
            this.breadcrumbs.updateBorder(this.getLeftOffset());
        } else {
            this.breadcrumbs.updateBorder(0);
        }
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)((Object)this.breadcrumbs), (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        BreadcrumbsProvider.EP_NAME.addChangeListener(() -> this.updateCrumbsSync(), (Disposable)this);
        BreadcrumbsPresentationProvider.EP_NAME.addChangeListener(() -> this.updateCrumbsSync(), (Disposable)this);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myQueue.setPassThrough(true);
        }
        this.queueUpdate();
    }

    protected int getLeftOffset() {
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)this.myEditor.getGutter();
        return gutter.getWhitespaceSeparatorOffset();
    }

    private void updateCrumbsAsync() {
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        ReadAction.nonBlocking(() -> this.computeCrumbs(offset)).withDocumentsCommitted(this.myProject).expireWith((Disposable)this).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), crumbs -> this.applyCrumbs((Iterable<? extends Crumb>)crumbs)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private void applyCrumbs(Iterable<? extends Crumb> _crumbs) {
        boolean areCrumbsVisible = this.breadcrumbs.isShowing() || ApplicationManager.getApplication().isHeadlessEnvironment();
        Iterable<? extends Crumb> crumbs = _crumbs != null && areCrumbsVisible ? _crumbs : EMPTY_BREADCRUMBS;
        this.breadcrumbs.setFont(BreadcrumbsPanel.getNewFont(this.myEditor));
        this.breadcrumbs.setCrumbs(crumbs);
        this.notifyListeners(crumbs);
    }

    private void updateCrumbsSync() {
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        Iterable<? extends Crumb> crumbs = this.computeCrumbs(offset);
        this.applyCrumbs(crumbs);
    }

    public void queueUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(this.myUpdate);
    }

    public void addBreadcrumbListener(BreadcrumbListener listener2, Disposable parentDisposable) {
        this.myBreadcrumbListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myBreadcrumbListeners.remove(listener2));
    }

    private void notifyListeners(@NotNull Iterable<? extends Crumb> breadcrumbs) {
        for (BreadcrumbListener listener2 : this.myBreadcrumbListeners) {
            listener2.breadcrumbsChanged(breadcrumbs);
        }
    }

    private void itemSelected(Crumb crumb, InputEvent event) {
        if (event == null) {
            return;
        }
        this.navigateToCrumb(crumb, event.isShiftDown() || event.isMetaDown());
    }

    private void itemHovered(Crumb crumb, InputEvent event) {
        CrumbHighlightInfo info;
        if (!Registry.is((String)"editor.breadcrumbs.highlight.on.hover")) {
            return;
        }
        HighlightManager hm = HighlightManager.getInstance((Project)this.myProject);
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter : this.myHighlighed) {
                hm.removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighed = null;
        }
        if ((info = this.getHighlightInfo(crumb)) != null) {
            Color background;
            Color color;
            TextRange range2 = info.range;
            TextAttributes attributes = new TextAttributes();
            Color color2 = color = info.presentation != null ? info.presentation.getBackgroundColor(false, false, false) : null;
            if (color == null) {
                color = BreadcrumbsComponent.ButtonSettings.getBackgroundColor(false, false, false, false);
            }
            if (color == null) {
                color = UIUtil.getLabelBackground();
            }
            attributes.setBackgroundColor(UIUtil.makeTransparent((Color)color, (Color)((background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR)) != null ? background : Gray._200), (double)0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            int flags = 7;
            hm.addOccurrenceHighlight(this.myEditor, range2.getStartOffset(), range2.getEndOffset(), attributes, flags, this.myHighlighed, null);
        }
    }

    @Nullable
    protected abstract Iterable<? extends Crumb> computeCrumbs(int var1);

    protected void navigateToCrumb(Crumb crumb, boolean withSelection) {
        if (crumb instanceof NavigatableCrumb) {
            NavigatableCrumb navigatableCrumb = (NavigatableCrumb)crumb;
            this.myUserCaretChange = false;
            navigatableCrumb.navigate(this.myEditor, withSelection);
        }
    }

    @Nullable
    protected CrumbHighlightInfo getHighlightInfo(Crumb crumb) {
        if (crumb instanceof NavigatableCrumb) {
            TextRange range2 = ((NavigatableCrumb)crumb).getHighlightRange();
            if (range2 == null) {
                return null;
            }
            CrumbPresentation p = PsiCrumb.getPresentation(crumb);
            return new CrumbHighlightInfo(range2, p);
        }
        return null;
    }

    private static void putBreadcrumbsComponent(@NotNull Editor editor, @NotNull BreadcrumbsPanel panel2) {
        BreadcrumbsPanel oldPanel = (BreadcrumbsPanel)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
        if (oldPanel != null) {
            LOG.error("Multiple breadcrumbs panels registered for the same Editor, old panel: " + oldPanel, new Throwable());
        }
        editor.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)panel2);
    }

    @Nullable
    public static BreadcrumbsPanel getBreadcrumbsComponent(@NotNull Editor editor) {
        return (BreadcrumbsPanel)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        }
        this.myEditor = null;
        this.breadcrumbs.setCrumbs(EMPTY_BREADCRUMBS);
        this.notifyListeners(EMPTY_BREADCRUMBS);
    }

    private void updateEditorFont(PropertyChangeEvent event) {
        if ("fontSize".equals(event.getPropertyName())) {
            this.queueUpdate();
        }
    }

    private static Font getNewFont(Editor editor) {
        Font font = editor == null || Registry.is((String)"editor.breadcrumbs.system.font") ? UIUtil.getLabelFont() : BreadcrumbsPanel.getEditorFont(editor);
        return UISettings.getInstance().getUseSmallLabelsOnTabs() ? RelativeFont.SMALL.derive(font) : font;
    }

    private static Font getEditorFont(Editor editor) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(97, 0, editor.getColorsScheme().getFontPreferences(), null).getFont();
    }

    @Nullable
    protected static FileBreadcrumbsCollector findCollectorFor(@NotNull Project project, @Nullable VirtualFile file2, @NotNull BreadcrumbsPanel panel2) {
        if (file2 == null) {
            return null;
        }
        FileBreadcrumbsCollector collector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)project, (VirtualFile)file2);
        collector.watchForChanges(file2, panel2.myEditor, (Disposable)panel2, () -> panel2.queueUpdate());
        return collector;
    }

    private /* synthetic */ void lambda$new$0(ComponentAdapter resizeListener, EditorGutterComponentEx gutterComponent, MouseEventAdapter mouseListener) {
        this.removeComponentListener(resizeListener);
        gutterComponent.removeComponentListener(resizeListener);
        this.breadcrumbs.removeMouseListener((MouseListener)mouseListener);
    }

    protected static class CrumbHighlightInfo {
        @NotNull
        public final TextRange range;
        @Nullable
        public final CrumbPresentation presentation;

        public CrumbHighlightInfo(@NotNull TextRange range2, @Nullable CrumbPresentation presentation2) {
            this.range = range2;
            this.presentation = presentation2;
        }
    }
}

