/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.tracking.TrackerForNewInstancesBase;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.intellij.xdebugger.memory.ui.ClassesFilteredViewBase;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.AbstractTableColumnDescriptor;
import com.intellij.xdebugger.memory.utils.AbstractTableModelWithColumns;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesTable
extends JBTable
implements DataProvider,
Disposable {
    public static final DataKey<TypeInfo> SELECTED_CLASS_KEY = DataKey.create((String)"ClassesTable.SelectedClass");
    public static final DataKey<ReferenceCountProvider> REF_COUNT_PROVIDER_KEY = DataKey.create((String)"ClassesTable.ReferenceCountProvider");
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private static final JBColor CLICKABLE_COLOR = new JBColor(new Color(250, 251, 252), new Color(62, 66, 69));
    private static final String DEFAULT_EMPTY_TEXT = "Nothing to show";
    private static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(0, SimpleTextAttributes.LINK_ATTRIBUTES.getFgColor());
    private static final SimpleTextAttributes UNDERLINE_LINK_ATTRIBUTES = SimpleTextAttributes.LINK_ATTRIBUTES;
    private static final String NO_LOADED_CLASSES_MESSAGE = "No classes loaded.";
    private static final String LOAD_CLASS_LINK = "Load classes";
    private static final int CLASSES_COLUMN_PREFERRED_WIDTH = 250;
    private static final int COUNT_COLUMN_MIN_WIDTH = 80;
    private static final int DIFF_COLUMN_MIN_WIDTH = 80;
    private static final UnknownDiffValue UNKNOWN_VALUE = new UnknownDiffValue();
    private final DiffViewTableModel myModel;
    private final Map<TypeInfo, DiffValue> myCounts = new ConcurrentHashMap<TypeInfo, DiffValue>();
    private final InstancesTracker myInstancesTracker;
    private final ClassesFilteredViewBase myParent;
    private final ReferenceCountProvider myCountProvider;
    private boolean myOnlyWithDiff;
    private boolean myOnlyTracked;
    private boolean myOnlyWithInstances;
    private MinusculeMatcher myMatcher = NameUtil.buildMatcher((String)"*").build();
    private String myFilteringPattern = "";
    private final MergingUpdateQueue myFilterTypingMergeQueue = new MergingUpdateQueue("Classes table typing merging queue", 500, true, (JComponent)((Object)this), (Disposable)this, (JComponent)((Object)this), true).setRestartTimerOnAdd(true);
    private volatile List<TypeInfo> myItems = Collections.unmodifiableList(new ArrayList());
    private boolean myIsShowCounts = true;
    private MouseListener myMouseListener = null;

    public ClassesTable(@NotNull Project project, @NotNull ClassesFilteredViewBase parent, boolean onlyWithDiff, boolean onlyWithInstances, boolean onlyTracked) {
        this.myModel = this.getTableModel();
        this.setModel(this.myModel);
        this.myOnlyWithDiff = onlyWithDiff;
        this.myOnlyWithInstances = onlyWithInstances;
        this.myOnlyTracked = onlyTracked;
        this.myInstancesTracker = InstancesTracker.getInstance(project);
        this.myParent = parent;
        this.customizeColumns();
        this.setShowGrid(false);
        this.setIntercellSpacing((Dimension)new JBDimension(0, 0));
        this.setDefaultRenderer(TypeInfo.class, (TableCellRenderer)((Object)new MyClassColumnRenderer()));
        this.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new MyCountColumnRenderer()));
        this.setDefaultRenderer(DiffValue.class, (TableCellRenderer)((Object)new MyDiffColumnRenderer()));
        this.setSelectionMode(0);
        this.myCountProvider = new ReferenceCountProvider(){

            @Override
            public int getTotalCount(@NotNull TypeInfo ref) {
                return (int)((DiffValue)ClassesTable.this.myCounts.get(ref)).myCurrentCount;
            }

            @Override
            public int getDiffCount(@NotNull TypeInfo ref) {
                return (int)((DiffValue)ClassesTable.this.myCounts.get(ref)).diff();
            }

            @Override
            public int getNewInstancesCount(@NotNull TypeInfo ref) {
                TrackerForNewInstancesBase strategy = ClassesTable.this.myParent.getStrategy(ref);
                return strategy == null || !strategy.isReady() ? -1 : strategy.getCount();
            }
        };
    }

    @NotNull
    protected DiffViewTableModel getTableModel() {
        return new DiffViewTableModel();
    }

    protected void customizeColumns() {
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn classesColumn = columnModel.getColumn(0);
        TableColumn countColumn = columnModel.getColumn(1);
        TableColumn diffColumn = columnModel.getColumn(2);
        this.setAutoResizeMode(2);
        classesColumn.setPreferredWidth(JBUIScale.scale((int)250));
        countColumn.setMinWidth(JBUIScale.scale((int)80));
        diffColumn.setMinWidth(JBUIScale.scale((int)80));
        TableRowSorter<DiffViewTableModel> sorter = new TableRowSorter<DiffViewTableModel>(this.myModel);
        sorter.setRowFilter(new RowFilter<DiffViewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends DiffViewTableModel, ? extends Integer> entry) {
                int ix = entry.getIdentifier();
                TypeInfo ref = ClassesTable.this.getTypeInfoAt(ix);
                DiffValue diff = ClassesTable.this.myCounts.getOrDefault(ref, UNKNOWN_VALUE);
                boolean isFilteringOptionsRefused = ClassesTable.this.myOnlyWithDiff && diff.diff() == 0L || ClassesTable.this.myOnlyWithInstances && !diff.hasInstance() || ClassesTable.this.myOnlyTracked && ClassesTable.this.myParent.getStrategy(ref) == null;
                return !isFilteringOptionsRefused && ClassesTable.this.myMatcher.matches(ref.name());
            }
        });
        List<RowSorter.SortKey> myDefaultSortingKeys = this.getTableSortingKeys();
        sorter.setSortKeys(myDefaultSortingKeys);
        this.setRowSorter(sorter);
    }

    @NotNull
    protected List<RowSorter.SortKey> getTableSortingKeys() {
        return Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING), new RowSorter.SortKey(1, SortOrder.DESCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING));
    }

    @Nullable
    public TypeInfo getSelectedClass() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            int ix = this.convertRowIndexToModel(selectedRow);
            return this.getTypeInfoAt(ix);
        }
        return null;
    }

    @Nullable
    public TypeInfo getClassByName(@NotNull String name) {
        for (TypeInfo ref : this.myItems) {
            if (!name.equals(ref.name())) continue;
            return ref;
        }
        return null;
    }

    public boolean isInClickableMode() {
        return this.myMouseListener != null;
    }

    public void makeClickable(final @NotNull Runnable onClick2) {
        this.releaseMouseListener();
        AnAction action2 = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                onClick2.run();
                ClassesTable.this.releaseMouseListener();
            }
        };
        KeyboardShortcut shortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(108, 64), null);
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{shortcut}), null);
        MyMouseAdapter listener2 = new MyMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                onClick2.run();
                ClassesTable.this.releaseMouseListener();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.updateTable(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.updateTable(false);
            }

            @Override
            void updateTable(boolean mouseOnTable) {
                ClassesTable.this.setBackground((Color)(mouseOnTable ? CLICKABLE_COLOR : JBColor.background()));
                SimpleTextAttributes linkAttributes = mouseOnTable ? UNDERLINE_LINK_ATTRIBUTES : LINK_ATTRIBUTES;
                ClassesTable.this.getEmptyText().clear().appendText(ClassesTable.NO_LOADED_CLASSES_MESSAGE).appendText(" ").appendText(ClassesTable.LOAD_CLASS_LINK, linkAttributes).appendText(" ");
            }
        };
        listener2.updateTable(this.isUnderMouseCursor());
        this.myMouseListener = listener2;
        this.addMouseListener(this.myMouseListener);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void exitClickableMode() {
        this.releaseMouseListener();
        this.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
    }

    private void releaseMouseListener() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isInClickableMode()) {
            this.removeMouseListener(this.myMouseListener);
            this.myMouseListener = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setBackground(JBColor.background());
        }
    }

    public void setBusy(boolean value2) {
        this.setPaintBusy(value2);
    }

    void setFilterPattern(String pattern) {
        if (!this.myFilteringPattern.equals(pattern)) {
            this.myFilteringPattern = pattern;
            this.myFilterTypingMergeQueue.queue(new Update(this.myMatcher, true){

                public void run() {
                    String newPattern = "*" + ClassesTable.this.myFilteringPattern;
                    if (ClassesTable.this.myMatcher.getPattern().equals(newPattern)) {
                        return;
                    }
                    ClassesTable.this.myMatcher = NameUtil.buildMatcher((String)newPattern).build();
                    ClassesTable.this.fireTableDataChanged();
                    if (ClassesTable.this.getSelectedClass() == null && ClassesTable.this.getRowCount() > 0) {
                        ClassesTable.this.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            });
        }
    }

    void setFilteringByInstanceExists(boolean value2) {
        if (value2 != this.myOnlyWithInstances) {
            this.myOnlyWithInstances = value2;
            this.fireTableDataChanged();
        }
    }

    void setFilteringByDiffNonZero(boolean value2) {
        if (this.myOnlyWithDiff != value2) {
            this.myOnlyWithDiff = value2;
            this.fireTableDataChanged();
        }
    }

    void setFilteringByTrackingState(boolean value2) {
        if (this.myOnlyTracked != value2) {
            this.myOnlyTracked = value2;
            this.fireTableDataChanged();
        }
    }

    public void updateClassesOnly(@NotNull List<? extends TypeInfo> classes) {
        this.myIsShowCounts = false;
        LinkedHashMap<TypeInfo, Long> class2Count = new LinkedHashMap<TypeInfo, Long>();
        classes.forEach(x -> class2Count.put((TypeInfo)x, 0L));
        this.updateCountsInternal(class2Count);
    }

    public void updateContent(@NotNull Map<TypeInfo, Long> class2Count) {
        this.myIsShowCounts = true;
        this.updateCountsInternal(class2Count);
    }

    void hideContent(@NotNull String emptyText) {
        this.releaseMouseListener();
        this.getEmptyText().setText(emptyText);
        this.myModel.hide();
    }

    private void showContent() {
        this.myModel.show();
    }

    private void updateCountsInternal(@NotNull Map<TypeInfo, Long> class2Count) {
        this.releaseMouseListener();
        this.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        TypeInfo selectedClass = this.myModel.getSelectedClassBeforeHide();
        int newSelectedIndex = -1;
        boolean isInitialized = !this.myItems.isEmpty();
        this.myItems = Collections.unmodifiableList(new ArrayList<TypeInfo>(class2Count.keySet()));
        int i2 = 0;
        for (TypeInfo ref : class2Count.keySet()) {
            if (ref.equals(selectedClass)) {
                newSelectedIndex = i2;
            }
            DiffValue oldValue = isInitialized && !this.myCounts.containsKey(ref) ? new DiffValue(0L, 0L) : this.myCounts.getOrDefault(ref, UNKNOWN_VALUE);
            this.myCounts.put(ref, oldValue.update(class2Count.get(ref)));
            ++i2;
        }
        this.showContent();
        if (newSelectedIndex != -1 && !this.myModel.isHidden()) {
            int ix = this.convertRowIndexToView(newSelectedIndex);
            this.changeSelection(ix, 0, false, false);
        }
        this.fireTableDataChanged();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (SELECTED_CLASS_KEY.is(dataId)) {
            return this.getSelectedClass();
        }
        if (REF_COUNT_PROVIDER_KEY.is(dataId)) {
            return this.myCountProvider;
        }
        return this.myParent.getData(dataId);
    }

    public void clean(@NotNull String emptyText) {
        this.clearSelection();
        this.releaseMouseListener();
        this.getEmptyText().setText(emptyText);
        this.myItems = Collections.emptyList();
        this.myCounts.clear();
        this.myModel.mySelectedClassWhenHidden = null;
        this.fireTableDataChanged();
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> this.clean(""));
    }

    private boolean isUnderMouseCursor() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        try {
            return this.getMousePosition() != null;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Nullable
    private TrackingType getTrackingType(int row) {
        TypeInfo ref = (TypeInfo)this.getValueAt(row, this.convertColumnIndexToView(0));
        return this.myInstancesTracker.getTrackingType(ref.name());
    }

    private void fireTableDataChanged() {
        this.myModel.fireTableDataChanged();
    }

    protected AbstractTableColumnDescriptor @NotNull [] getColumnDescriptors() {
        return new AbstractTableColumnDescriptor[]{new AbstractTableColumnDescriptor("Class", TypeInfo.class){

            @Override
            public Object getValue(int ix) {
                return ClassesTable.this.getTypeInfoAt(ix);
            }
        }, new AbstractTableColumnDescriptor("Count", Long.class){

            @Override
            public Object getValue(int ix) {
                return ((DiffValue)ClassesTable.this.myCounts.getOrDefault(ClassesTable.this.getTypeInfoAt(ix), UNKNOWN_VALUE)).myCurrentCount;
            }
        }, new AbstractTableColumnDescriptor("Diff", DiffValue.class){

            @Override
            public Object getValue(int ix) {
                return ClassesTable.this.myCounts.getOrDefault(ClassesTable.this.getTypeInfoAt(ix), UNKNOWN_VALUE);
            }
        }};
    }

    protected TypeInfo getTypeInfoAt(int ix) {
        return this.myItems.get(ix);
    }

    private class MyDiffColumnRenderer
    extends MyNumericRenderer {
        private final SimpleTextAttributes myClickableCellAttributes;

        private MyDiffColumnRenderer() {
            this.myClickableCellAttributes = new SimpleTextAttributes(16, (Color)JBColor.BLUE);
        }

        @Override
        void appendText(@NotNull Object value2, int row) {
            TrackingType trackingType = ClassesTable.this.getTrackingType(row);
            if (trackingType != null) {
                this.setIcon(AllIcons.Debugger.Db_watch);
                this.setTransparentIconBackground(true);
            }
            TypeInfo ref = ClassesTable.this.getTypeInfoAt(ClassesTable.this.convertRowIndexToModel(row));
            long diff = ClassesTable.this.myCountProvider.getDiffCount(ref);
            String text = String.format("%s%d", diff > 0L ? "+" : "", diff);
            int newInstancesCount = ClassesTable.this.myCountProvider.getNewInstancesCount(ref);
            if (newInstancesCount >= 0) {
                if ((long)newInstancesCount == diff) {
                    this.append(text, diff == 0L ? SimpleTextAttributes.REGULAR_ATTRIBUTES : this.myClickableCellAttributes);
                } else {
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (newInstancesCount != 0) {
                        this.append(String.format(" (%d)", newInstancesCount), this.myClickableCellAttributes);
                    }
                }
            } else {
                this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }

    private class MyCountColumnRenderer
    extends MyNumericRenderer {
        private MyCountColumnRenderer() {
        }

        @Override
        void appendText(@NotNull Object value2, int row) {
            this.append(value2.toString());
        }
    }

    private abstract class MyNumericRenderer
    extends MyTableCellRenderer {
        private MyNumericRenderer() {
        }

        @Override
        protected void addText(@NotNull Object value2, boolean isSelected, int row) {
            if (ClassesTable.this.myIsShowCounts) {
                this.setTextAlign(4);
                this.appendText(value2, row);
            }
        }

        abstract void appendText(@NotNull Object var1, int var2);
    }

    private class MyClassColumnRenderer
    extends MyTableCellRenderer {
        private MyClassColumnRenderer() {
        }

        @Override
        protected void addText(@NotNull Object value2, boolean isSelected, int row) {
            String presentation2 = ((TypeInfo)value2).name();
            this.append(" ");
            if (isSelected) {
                FList textRanges = ClassesTable.this.myMatcher.matchingFragments(presentation2);
                if (textRanges != null) {
                    SimpleTextAttributes attributes = new SimpleTextAttributes(this.getBackground(), this.getForeground(), null, 64);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)presentation2, (Iterable)textRanges, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)attributes);
                }
            } else {
                this.append(String.format("%s", presentation2), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }

    public static abstract class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (hasFocus) {
                this.setBorder(new EmptyBorder(this.getBorder().getBorderInsets((Component)((Object)this))));
            }
            if (value2 != null) {
                this.addText(value2, isSelected, row);
            }
        }

        protected abstract void addText(@NotNull Object var1, boolean var2, int var3);
    }

    private static class DiffValue
    implements Comparable<DiffValue> {
        private long myOldCount;
        private long myCurrentCount;

        DiffValue(long count) {
            this(count, count);
        }

        DiffValue(long old, long current2) {
            this.myCurrentCount = current2;
            this.myOldCount = old;
        }

        DiffValue update(long count) {
            this.myOldCount = this.myCurrentCount;
            this.myCurrentCount = count;
            return this;
        }

        boolean hasInstance() {
            return this.myCurrentCount > 0L;
        }

        long diff() {
            return this.myCurrentCount - this.myOldCount;
        }

        @Override
        public int compareTo(@NotNull DiffValue o) {
            return Long.compare(this.diff(), o.diff());
        }
    }

    private static class UnknownDiffValue
    extends DiffValue {
        UnknownDiffValue() {
            super(-1L);
        }

        @Override
        boolean hasInstance() {
            return true;
        }

        @Override
        DiffValue update(long count) {
            return new DiffValue(count);
        }
    }

    public class DiffViewTableModel
    extends AbstractTableModelWithColumns {
        public static final int CLASSNAME_COLUMN_INDEX = 0;
        static final int COUNT_COLUMN_INDEX = 1;
        public static final int DIFF_COLUMN_INDEX = 2;
        private TypeInfo mySelectedClassWhenHidden;
        private boolean myIsWithContent;

        DiffViewTableModel() {
            super(ClassesTable.this.getColumnDescriptors());
            this.mySelectedClassWhenHidden = null;
            this.myIsWithContent = false;
        }

        TypeInfo getSelectedClassBeforeHide() {
            return this.mySelectedClassWhenHidden;
        }

        void hide() {
            if (this.myIsWithContent) {
                this.mySelectedClassWhenHidden = ClassesTable.this.getSelectedClass();
                this.myIsWithContent = false;
                ClassesTable.this.clearSelection();
                this.fireTableDataChanged();
            }
        }

        void show() {
            if (!this.myIsWithContent) {
                this.myIsWithContent = true;
                this.fireTableDataChanged();
            }
        }

        boolean isHidden() {
            return !this.myIsWithContent;
        }

        @Override
        public int getRowCount() {
            return this.myIsWithContent ? ClassesTable.this.myItems.size() : 0;
        }
    }

    private static abstract class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        abstract void updateTable(boolean var1);
    }

    public static interface ReferenceCountProvider {
        public int getTotalCount(@NotNull TypeInfo var1);

        public int getDiffCount(@NotNull TypeInfo var1);

        public int getNewInstancesCount(@NotNull TypeInfo var1);
    }
}

