/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.component;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.EventDispatcher;
import com.intellij.xdebugger.memory.component.MemoryViewManagerState;
import com.intellij.xdebugger.memory.event.MemoryViewManagerListener;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

@State(name="MemoryViewSettings", storages={@Storage(value="memory.view.xml")})
public class MemoryViewManager
implements PersistentStateComponent<MemoryViewManagerState> {
    public static final String MEMORY_VIEW_CONTENT = "MemoryView";
    private final EventDispatcher<MemoryViewManagerListener> myDispatcher = EventDispatcher.create(MemoryViewManagerListener.class);
    private MemoryViewManagerState myState = new MemoryViewManagerState();

    public static MemoryViewManager getInstance() {
        return (MemoryViewManager)ServiceManager.getService(MemoryViewManager.class);
    }

    @NotNull
    public MemoryViewManagerState getState() {
        return new MemoryViewManagerState(this.myState);
    }

    public void loadState(@NotNull MemoryViewManagerState state) {
        this.myState = state;
        this.fireStateChanged();
    }

    public void setShowDiffOnly(boolean value2) {
        if (this.myState.isShowWithDiffOnly != value2) {
            this.myState.isShowWithDiffOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowWithInstancesOnly(boolean value2) {
        if (this.myState.isShowWithInstancesOnly != value2) {
            this.myState.isShowWithInstancesOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowTrackedOnly(boolean value2) {
        if (this.myState.isShowTrackedOnly != value2) {
            this.myState.isShowTrackedOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setAutoUpdate(boolean value2) {
        if (this.myState.isAutoUpdateModeOn != value2) {
            this.myState.isAutoUpdateModeOn = value2;
            this.fireStateChanged();
        }
    }

    public boolean isNeedShowDiffOnly() {
        return this.myState.isShowWithDiffOnly;
    }

    public boolean isNeedShowInstancesOnly() {
        return this.myState.isShowWithInstancesOnly;
    }

    public boolean isNeedShowTrackedOnly() {
        return this.myState.isShowTrackedOnly;
    }

    public boolean isAutoUpdateModeEnabled() {
        return this.myState.isAutoUpdateModeOn;
    }

    public void addMemoryViewManagerListener(MemoryViewManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireStateChanged() {
        ((MemoryViewManagerListener)this.myDispatcher.getMulticaster()).stateChanged(new MemoryViewManagerState(this.myState));
    }
}

