/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueGroupNodeImpl
extends XValueContainerNode<XValueGroup>
implements RestorableStateNode {
    public XValueGroupNodeImpl(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull XValueGroup group) {
        super(tree, parent, false, group);
        this.setIcon(group.getIcon());
        this.myText.append(group.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = group.getComment();
        if (comment != null) {
            XValuePresentationUtil.appendSeparator((ColoredTextContainer)this.myText, group.getSeparator());
            this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.isExpand(group)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.isObsolete()) {
                    this.myTree.expandPath(this.getPath());
                }
            });
        }
        this.myTree.nodeLoaded(this, group.getName());
    }

    private boolean isExpand(@NotNull XValueGroup group) {
        String name;
        if (group.isRestoreExpansion() && StringUtil.isNotEmpty((String)(name = group.getName())) && PropertiesComponent.getInstance((Project)this.getTree().getProject()).isValueSet(group.getName())) {
            return PropertiesComponent.getInstance((Project)this.getTree().getProject()).getBoolean(name);
        }
        return group.isAutoExpand();
    }

    public void onExpansion(boolean expanded) {
        String name;
        XValueGroup group = (XValueGroup)this.getValueContainer();
        if (group.isRestoreExpansion() && StringUtil.isNotEmpty((String)(name = group.getName()))) {
            PropertiesComponent.getInstance((Project)this.getTree().getProject()).setValue(group.getName(), String.valueOf(expanded), null);
        }
    }

    @Override
    public String toString() {
        return "Group:" + ((XValueGroup)this.myValueContainer).getName();
    }

    @Nullable
    public String getName() {
        return ((XValueGroup)this.myValueContainer).getName();
    }

    @Override
    @Nullable
    public String getRawValue() {
        return null;
    }

    @Override
    public boolean isComputed() {
        return true;
    }

    @Override
    public void markChanged() {
    }
}

