/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadlessValueEvaluationCallback
implements XFullValueEvaluator.XFullValueEvaluationCallback {
    private final XValueNodeImpl myNode;
    private volatile boolean myEvaluated;
    private volatile boolean myCanceled;
    private final Semaphore mySemaphore;

    public HeadlessValueEvaluationCallback(@NotNull XValueNodeImpl node) {
        this.myNode = node;
        this.mySemaphore = new Semaphore();
        this.mySemaphore.down();
    }

    public void startFetchingValue(@NotNull XFullValueEvaluator fullValueEvaluator) {
        fullValueEvaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)this);
        new Alarm().addRequest(() -> this.showProgress(), 500);
    }

    public void evaluated(@NotNull String fullValue) {
        this.evaluationComplete(fullValue);
    }

    public void evaluated(@NotNull String fullValue, @Nullable Font font) {
        this.evaluated(fullValue);
    }

    public void errorOccurred(@NotNull String errorMessage) {
        try {
            String message = XDebuggerBundle.message((String)"load.value.task.error", (Object[])new Object[]{errorMessage});
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR).notify(this.myNode.getTree().getProject());
        }
        finally {
            this.evaluationComplete(errorMessage);
        }
    }

    private void evaluationComplete(@NotNull String value2) {
        try {
            this.myEvaluated = true;
            this.mySemaphore.up();
        }
        finally {
            this.evaluationComplete(value2, this.myNode.getTree().getProject());
        }
    }

    public XValueNodeImpl getNode() {
        return this.myNode;
    }

    protected void evaluationComplete(@NotNull String value2, @NotNull Project project) {
    }

    public boolean isObsolete() {
        return this.myCanceled;
    }

    public void showProgress() {
        if (this.myEvaluated || this.myNode.isObsolete()) {
            return;
        }
        new Task.Backgroundable(this.myNode.getTree().getProject(), XDebuggerBundle.message((String)"load.value.task.text", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                int i2 = 0;
                while (!HeadlessValueEvaluationCallback.this.myCanceled && !HeadlessValueEvaluationCallback.this.myEvaluated) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)(i2++ % 100) * 0.01);
                    HeadlessValueEvaluationCallback.this.mySemaphore.waitFor(300L);
                }
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            public void onCancel() {
                HeadlessValueEvaluationCallback.this.myCanceled = true;
            }
        }.queue();
    }
}

