/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;

public class XAddToWatchesTreeAction
extends XDebuggerTreeActionBase {
    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        return super.isEnabled(node, e) && DebuggerUIUtil.hasEvaluationExpression((XValue)node.getValueContainer()) && XAddToWatchesTreeAction.getWatchesView(e) != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        for (XValueNodeImpl node : XAddToWatchesTreeAction.getSelectedNodes(e.getDataContext())) {
            String nodeName;
            if (node == null || (nodeName = node.getName()) == null) continue;
            this.perform(node, nodeName, e);
        }
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        XWatchesView watchesView = XAddToWatchesTreeAction.getWatchesView(e);
        if (watchesView != null) {
            DebuggerUIUtil.addToWatches(watchesView, node);
        }
    }

    private static XWatchesView getWatchesView(@NotNull AnActionEvent e) {
        XDebugSessionTab tab;
        XDebugSession session2;
        XWatchesView view = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        Project project = e.getProject();
        if (view == null && project != null && (session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && (tab = ((XDebugSessionImpl)session2).getSessionTab()) != null) {
            return tab.getWatchesView();
        }
        return view;
    }
}

