/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.ItemWrapperListRenderer;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointChooser {
    private DetailView myDetailViewDelegate;
    private final Delegate myDelegate;
    private final ComboBox<BreakpointItem> myComboBox;
    private final DetailController myDetailController;
    private final List<BreakpointItem> myBreakpointItems;
    private MyDetailView myDetailView;

    public void setDetailView(DetailView detailView) {
        this.myDetailViewDelegate = detailView;
        this.myDetailView = new MyDetailView(this.myDetailViewDelegate.getEditorState());
        this.myDetailController.setDetailView(this.myDetailView);
    }

    public Object getSelectedBreakpoint() {
        return ((BreakpointItem)this.myComboBox.getSelectedItem()).getBreakpoint();
    }

    private void pop(DetailView.PreviewEditorState pushed) {
        if (pushed.getFile() != null) {
            this.myDetailViewDelegate.navigateInPreviewEditor(new DetailView.PreviewEditorState(pushed.getFile(), pushed.getNavigate(), pushed.getAttributes()));
        } else {
            this.myDetailViewDelegate.clearEditor();
        }
    }

    public void setSelectedBreakpoint(Object breakpoint) {
        this.myComboBox.setSelectedItem((Object)BreakpointChooser.findItem(breakpoint, this.myBreakpointItems));
    }

    public BreakpointChooser(final Project project, Delegate delegate, Object baseBreakpoint, List<BreakpointItem> breakpointItems) {
        this.myDelegate = delegate;
        this.myBreakpointItems = breakpointItems;
        BreakpointItem breakpointItem = BreakpointChooser.findItem(baseBreakpoint, this.myBreakpointItems);
        final Ref hackedSelection = Ref.create();
        this.myDetailController = new DetailController(new MasterController(){
            final JLabel fake = new JLabel();

            @Override
            public ItemWrapper[] getSelectedItems() {
                if (hackedSelection.get() == null) {
                    return new ItemWrapper[0];
                }
                return new ItemWrapper[]{(BreakpointItem)hackedSelection.get()};
            }

            @Override
            public JLabel getPathLabel() {
                return this.fake;
            }
        });
        CollectionComboBoxModel model = new CollectionComboBoxModel(this.myBreakpointItems, (Object)breakpointItem);
        this.myComboBox = new ComboBox((ComboBoxModel)model);
        this.myComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (BreakpointChooser.this.myDetailView != null) {
                    BreakpointChooser.this.myDetailView.clearEditor();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (BreakpointChooser.this.myDetailView != null) {
                    BreakpointChooser.this.myDetailView.clearEditor();
                }
            }
        });
        this.myComboBox.setRenderer((ListCellRenderer)((Object)new ItemWrapperListRenderer(project, null){

            @Override
            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                super.customizeCellRenderer(list2, value2, index, selected2, hasFocus);
                if (selected2 && hackedSelection.get() != value2) {
                    hackedSelection.set(value2);
                    BreakpointChooser.this.myDetailController.updateDetailView();
                }
            }
        }));
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                BreakpointChooser.this.myDelegate.breakpointChosen(project, (BreakpointItem)BreakpointChooser.this.myComboBox.getSelectedItem());
            }
        });
    }

    @Nullable
    private static BreakpointItem findItem(Object baseBreakpoint, List<? extends BreakpointItem> breakpointItems) {
        BreakpointItem breakpointItem = null;
        for (BreakpointItem breakpointItem2 : breakpointItems) {
            if (breakpointItem2.getBreakpoint() != baseBreakpoint) continue;
            breakpointItem = breakpointItem2;
            break;
        }
        return breakpointItem;
    }

    public JComponent getComponent() {
        return this.myComboBox;
    }

    private class MyDetailView
    implements DetailView {
        private final DetailView.PreviewEditorState myPushed;
        private ItemWrapper myCurrentItem;
        final UserDataHolderBase myDataHolderBase = new UserDataHolderBase();

        MyDetailView(DetailView.PreviewEditorState pushed) {
            this.myPushed = pushed;
            this.putUserData(BreakpointItem.EDITOR_ONLY, Boolean.TRUE);
        }

        public Editor getEditor() {
            return BreakpointChooser.this.myDetailViewDelegate.getEditor();
        }

        public void navigateInPreviewEditor(DetailView.PreviewEditorState editorState) {
            if (BreakpointChooser.this.myDetailViewDelegate != null) {
                BreakpointChooser.this.myDetailViewDelegate.navigateInPreviewEditor(editorState);
            }
        }

        public JPanel getPropertiesPanel() {
            return null;
        }

        public void setPropertiesPanel(@Nullable JPanel panel2) {
        }

        public void clearEditor() {
            BreakpointChooser.this.pop(this.myPushed);
        }

        public DetailView.PreviewEditorState getEditorState() {
            return BreakpointChooser.this.myDetailViewDelegate.getEditorState();
        }

        public void setCurrentItem(ItemWrapper currentItem) {
            this.myCurrentItem = currentItem;
        }

        public ItemWrapper getCurrentItem() {
            return this.myCurrentItem;
        }

        public boolean hasEditorOnly() {
            return true;
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            return (T)this.myDataHolderBase.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            this.myDataHolderBase.putUserData(key, value2);
        }
    }

    public static interface Delegate {
        public void breakpointChosen(Project var1, BreakpointItem var2);
    }
}

