/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SingleRootClasspathElement
implements SimpleClasspathElement {
    @NonNls
    public static final String URL_ELEMENT = "url";
    private final String myUrl;

    public SingleRootClasspathElement(@NotNull String url) {
        this.myUrl = url;
    }

    @Override
    public String getPresentableName() {
        String url = this.myUrl.endsWith("!/") ? this.myUrl.substring(0, this.myUrl.length() - "!/".length()) : this.myUrl;
        int startIndex = Math.min(url.lastIndexOf(47) + 1, url.length() - 1);
        return url.substring(startIndex);
    }

    @Override
    public Library getLibrary() {
        return null;
    }

    @Override
    public String getLibraryName() {
        return null;
    }

    @Override
    public void serialize(Element element2) throws IOException {
        element2.addContent(new Element(URL_ELEMENT).setText(this.myUrl));
    }

    @Override
    public List<String> getClassesRootUrls() {
        return Collections.singletonList(this.myUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleRootClasspathElement element2 = (SingleRootClasspathElement)o;
        return this.myUrl.equals(element2.myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

