/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.CharSequenceReader;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextTransferable
implements Transferable {
    private static final Logger LOG = Logger.getInstance(TextTransferable.class);
    private final CharSequence myHtmlContent;
    private final CharSequence myPlainContent;
    private static final NotNullLazyValue<List<DataFlavor>> FLAVORS = NotNullLazyValue.createValue(() -> {
        ArrayList<DataFlavor> result2 = new ArrayList<DataFlavor>();
        result2.add(DataFlavor.stringFlavor);
        result2.add(DataFlavor.plainTextFlavor);
        try {
            result2.add(new DataFlavor("text/html;class=java.lang.String"));
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    });

    public TextTransferable(@Nullable String data2) {
        this(StringUtil.notNullize((String)data2), StringUtil.notNullize((String)data2));
    }

    public TextTransferable(@NotNull CharSequence data2) {
        this(data2, data2);
    }

    public TextTransferable(@NotNull String htmlContent, @NotNull String plainContent) {
        this.myHtmlContent = StringUtil.notNullize((String)htmlContent);
        this.myPlainContent = StringUtil.notNullize((String)plainContent);
    }

    public TextTransferable(@NotNull CharSequence htmlContent, @NotNull CharSequence plainContent) {
        this.myHtmlContent = htmlContent;
        this.myPlainContent = plainContent;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return ((List)FLAVORS.getValue()).toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : (List)FLAVORS.getValue()) {
            if (!flavor.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.getMimeType().startsWith("text/html;")) {
            return this.myHtmlContent.toString();
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new CharSequenceReader(this.myPlainContent == null ? "" : this.myPlainContent);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.myPlainContent.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static class ColoredStringBuilder
    implements ColoredTextContainer {
        private final StringBuilder builder = new StringBuilder();

        public void appendTo(StringBuilder ... subBuilders) {
            for (StringBuilder subBuilder : subBuilders) {
                subBuilder.append((CharSequence)this.builder);
            }
            this.builder.setLength(0);
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            this.builder.append(fragment);
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }
    }
}

