/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.index.IndexImporterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingIndex;
import com.intellij.util.indexing.snapshot.UpdatableSnapshotInputMappingIndex;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexImporterMappingIndex<Key, Value, Input>
implements SnapshotInputMappingIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(IndexImporterMappingIndex.class);
    private final List<SnapshotInputMappingIndex<Key, Value, Input>> myImporters;

    @Nullable
    public static <Key, Value, Input> SnapshotInputMappingIndex<Key, Value, Input> wrap(final @Nullable SnapshotInputMappingIndex<Key, Value, Input> index, @NotNull IndexExtension<Key, Value, Input> indexExtension) {
        final SnapshotInputMappingIndex<Key, Value, Input> indexImporterMappingIndex = IndexImporterMappingIndex.createImportersWrapper(indexExtension);
        if (indexImporterMappingIndex == null) {
            return index;
        }
        if (index == null) {
            return indexImporterMappingIndex;
        }
        if (index instanceof UpdatableSnapshotInputMappingIndex) {
            final UpdatableSnapshotInputMappingIndex updatableIndex = (UpdatableSnapshotInputMappingIndex)index;
            return new UpdatableSnapshotInputMappingIndex<Key, Value, Input>(){

                @Override
                @NotNull
                public Map<Key, Value> readData(int hashId) throws IOException {
                    return updatableIndex.readData(hashId);
                }

                @Override
                public InputData<Key, Value> putData(@NotNull Input content2, @NotNull InputData<Key, Value> data2) throws IOException {
                    return updatableIndex.putData(content2, data2);
                }

                @Override
                public void flush() throws IOException {
                    updatableIndex.flush();
                }

                @Override
                public void clear() throws IOException {
                    updatableIndex.clear();
                }

                @Override
                @Nullable
                public InputData<Key, Value> readData(@NotNull Input content2) throws IOException {
                    InputData existedData;
                    try {
                        existedData = index.readData(content2);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        existedData = null;
                    }
                    if (existedData != null) {
                        return existedData;
                    }
                    InputData importedData = indexImporterMappingIndex.readData(content2);
                    if (importedData != null) {
                        return updatableIndex.putData(content2, importedData);
                    }
                    return null;
                }

                @Override
                public void close() throws IOException {
                    try {
                        updatableIndex.close();
                    }
                    finally {
                        indexImporterMappingIndex.close();
                    }
                }
            };
        }
        return new SnapshotInputMappingIndex<Key, Value, Input>(){

            @Override
            @Nullable
            public InputData<Key, Value> readData(@NotNull Input content2) throws IOException {
                InputData data2 = index.readData(content2);
                if (data2 != null) {
                    return data2;
                }
                return indexImporterMappingIndex.readData(content2);
            }

            @Override
            public void close() throws IOException {
                try {
                    index.close();
                }
                finally {
                    indexImporterMappingIndex.close();
                }
            }
        };
    }

    @Nullable
    private static <Key, Value, Input> SnapshotInputMappingIndex<Key, Value, Input> createImportersWrapper(@NotNull IndexExtension<Key, Value, Input> indexExtension) {
        List<SnapshotInputMappingIndex<Key, Value, Input>> importers;
        try {
            importers = IndexImporterFactory.EP_NAME.extensions().map(f -> f.createImporter(indexExtension)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            importers = Collections.emptyList();
        }
        return importers.isEmpty() ? null : new IndexImporterMappingIndex<Key, Value, Input>(importers);
    }

    private IndexImporterMappingIndex(@NotNull List<SnapshotInputMappingIndex<Key, Value, Input>> importers) {
        this.myImporters = importers;
        LOG.assertTrue(!importers.isEmpty());
    }

    @Override
    @Nullable
    public InputData<Key, Value> readData(@NotNull Input content2) {
        for (SnapshotInputMappingIndex<Key, Value, Input> importer : this.myImporters) {
            try {
                InputData<Key, Value> data2 = importer.readData(content2);
                if (data2 == null) continue;
                return data2;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        for (SnapshotInputMappingIndex<Key, Value, Input> importer : this.myImporters) {
            try {
                importer.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

