/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.PortableFilePathProvider;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/ProjectRelativePortableFilePathProvider;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/PortableFilePathProvider;", "()V", "getLocalOrArchiveRelativeFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "rootBasePath", "", "root", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "getRelativePortableFilePath", "intellij.platform.lang.impl"})
public final class ProjectRelativePortableFilePathProvider
implements PortableFilePathProvider {
    public static final ProjectRelativePortableFilePathProvider INSTANCE;

    @Override
    @Nullable
    public PortableFilePath.RelativePath getRelativePortableFilePath(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        String projectBasePath = string;
        return this.getLocalOrArchiveRelativeFilePath(virtualFile, project, projectBasePath, PortableFilePath.ProjectRoot.INSTANCE);
    }

    @Nullable
    public final PortableFilePath.RelativePath getLocalOrArchiveRelativeFilePath(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull String rootBasePath, @NotNull PortableFilePath root) {
        String relativePath;
        VirtualFileSystem fileSystem = virtualFile.getFileSystem();
        if (fileSystem instanceof ArchiveFileSystem) {
            VirtualFile virtualFile2 = ((ArchiveFileSystem)fileSystem).getLocalByEntry(virtualFile);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile archiveLocalFile = virtualFile2;
            VirtualFile virtualFile3 = ((ArchiveFileSystem)fileSystem).getRootByEntry(virtualFile);
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile archiveRootFile = virtualFile3;
            String string = VfsUtil.getRelativePath((VirtualFile)virtualFile, (VirtualFile)archiveRootFile);
            if (string == null) {
                return null;
            }
            String relativePath2 = string;
            PortableFilePath archiveLocalPath = PortableFilePaths.INSTANCE.getPortableFilePath(archiveLocalFile, project);
            PortableFilePath.ArchiveRoot archiveRoot = new PortableFilePath.ArchiveRoot(archiveLocalPath);
            return new PortableFilePath.RelativePath(archiveRoot, relativePath2);
        }
        String filePath = virtualFile.getPath();
        String systemIndependentBase = FileUtil.toSystemIndependentName((String)rootBasePath);
        if (FileUtil.isAncestor((String)systemIndependentBase, (String)filePath, (boolean)false) && (relativePath = FileUtil.getRelativePath((String)systemIndependentBase, (String)filePath, (char)'/')) != null) {
            return new PortableFilePath.RelativePath(root, relativePath);
        }
        return null;
    }

    private ProjectRelativePortableFilePathProvider() {
    }

    static {
        ProjectRelativePortableFilePathProvider projectRelativePortableFilePathProvider;
        INSTANCE = projectRelativePortableFilePathProvider = new ProjectRelativePortableFilePathProvider();
    }
}

